/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.concurrent.impl.executor;

import java.util.AbstractQueue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.util.concurrent.ManagedExecutorService;
import org.apache.geronimo.concurrent.ManagedContextHandler;
import org.apache.geronimo.concurrent.executor.ServerManagedExecutorService;
import org.apache.geronimo.concurrent.impl.GBeanBuilder;
import org.apache.geronimo.concurrent.impl.NotificationHelper;
import org.apache.geronimo.concurrent.impl.executor.ComponentManagedExecutorServiceGBean;
import org.apache.geronimo.concurrent.impl.executor.ManagedExecutorServiceModuleFacade;
import org.apache.geronimo.concurrent.impl.executor.ServerManagedThreadFactory;
import org.apache.geronimo.concurrent.impl.thread.GeronimoManagedThreadFactorySource;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.management.EventProvider;

public class ServerManagedExecutorServiceGBean
extends ComponentManagedExecutorServiceGBean
implements EventProvider,
org.apache.geronimo.management.ManagedExecutorService {
    public static final GBeanInfo GBEAN_INFO;
    private AbstractName name;
    private ServerManagedThreadFactory threadFactory;

    public ServerManagedExecutorServiceGBean(Kernel kernel, AbstractName name, ClassLoader classLoader, int minPoolSize, int maxPoolSize, long keepAliveTime, int queueCapacity, GeronimoManagedThreadFactorySource threadFactorySource, String[] contextHandlerClasses) {
        super(classLoader, minPoolSize, maxPoolSize, keepAliveTime, queueCapacity, threadFactorySource, contextHandlerClasses);
        this.name = name;
        NotificationHelper notificationHelper = new NotificationHelper(kernel, name);
        this.threadFactory = new ServerManagedThreadFactory(threadFactorySource.getManagedThreadFactory(), notificationHelper);
    }

    protected synchronized ManagedExecutorService getManagedExecutorService() {
        if (this.executor == null) {
            AbstractQueue queue = null;
            queue = this.queueCapacity <= 0 ? new LinkedBlockingQueue() : new ArrayBlockingQueue(this.queueCapacity);
            this.executor = new ServerManagedExecutorService(this.minPoolSize, this.maxPoolSize, this.keepAliveTime, TimeUnit.MILLISECONDS, queue, (ThreadFactory)((Object)this.threadFactory), (ManagedContextHandler)this.contextHandler);
        }
        return this.executor;
    }

    public Object $getResource(AbstractName moduleID) {
        return new ManagedExecutorServiceModuleFacade(this.getManagedExecutorService(), moduleID);
    }

    public AbstractName getName() {
        return this.name;
    }

    public String getObjectName() {
        return this.name.getObjectName().getCanonicalName();
    }

    public String[] getEventTypes() {
        return this.threadFactory.getEventTypes();
    }

    public String[] getHungTaskThreads() {
        return this.threadFactory.getHungTaskThreads();
    }

    public String[] getThreads() {
        return this.threadFactory.getThreads();
    }

    public boolean isEventProvider() {
        return true;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    protected void verifyObjectName() {
        GBeanBuilder.verifyObjectName(this.getObjectName(), "ManagedExecutorService", "ManagedExecutorService");
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(ServerManagedExecutorServiceGBean.class, (String)"ManagedExecutorService");
        infoFactory.addAttribute("classLoader", ClassLoader.class, false);
        infoFactory.addAttribute("abstractName", AbstractName.class, false);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addAttribute("minPoolSize", Integer.TYPE, true);
        infoFactory.addAttribute("maxPoolSize", Integer.TYPE, true);
        infoFactory.addAttribute("keepAliveTime", Long.TYPE, true);
        infoFactory.addAttribute("queueCapacity", Integer.TYPE, true);
        infoFactory.addAttribute("contextHandlers", String[].class, true);
        infoFactory.addReference("threadFactory", GeronimoManagedThreadFactorySource.class);
        infoFactory.addInterface(org.apache.geronimo.management.ManagedExecutorService.class);
        infoFactory.setConstructor(new String[]{"kernel", "abstractName", "classLoader", "minPoolSize", "maxPoolSize", "keepAliveTime", "queueCapacity", "threadFactory", "contextHandlers"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

