/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.concurrent.impl.executor;

import java.util.AbstractQueue;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.util.concurrent.ManagedExecutorService;
import javax.util.concurrent.ManagedThreadFactory;
import org.apache.geronimo.concurrent.ManagedContextHandler;
import org.apache.geronimo.concurrent.ManagedContextHandlerChain;
import org.apache.geronimo.concurrent.executor.ComponentManagedExecutorService;
import org.apache.geronimo.concurrent.executor.ManagedExecutorServiceFacade;
import org.apache.geronimo.concurrent.impl.ContextHandlerUtils;
import org.apache.geronimo.concurrent.impl.thread.GeronimoManagedThreadFactorySource;
import org.apache.geronimo.concurrent.naming.ModuleAwareResourceSource;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;

public class ComponentManagedExecutorServiceGBean
implements GBeanLifecycle,
ModuleAwareResourceSource {
    public static final GBeanInfo GBEAN_INFO;
    protected ManagedExecutorService executor;
    protected int minPoolSize;
    protected int maxPoolSize;
    protected long keepAliveTime;
    protected int queueCapacity;
    protected ManagedThreadFactory threadFactory;
    protected ManagedContextHandlerChain contextHandler;

    public ComponentManagedExecutorServiceGBean(ClassLoader classLoader, int minPoolSize, int maxPoolSize, long keepAliveTime, int queueCapacity, GeronimoManagedThreadFactorySource threadFactorySource, String[] contextHandlerClasses) {
        this.minPoolSize = minPoolSize;
        this.maxPoolSize = maxPoolSize;
        this.keepAliveTime = keepAliveTime;
        this.queueCapacity = queueCapacity;
        this.threadFactory = threadFactorySource.getManagedThreadFactory();
        List<ManagedContextHandler> handlers = ContextHandlerUtils.loadHandlers(classLoader, contextHandlerClasses);
        this.contextHandler = new ManagedContextHandlerChain(handlers);
    }

    protected synchronized ManagedExecutorService getManagedExecutorService() {
        if (this.executor == null) {
            AbstractQueue queue = null;
            queue = this.queueCapacity <= 0 ? new LinkedBlockingQueue() : new ArrayBlockingQueue(this.queueCapacity);
            this.executor = new ComponentManagedExecutorService(this.minPoolSize, this.maxPoolSize, this.keepAliveTime, TimeUnit.MILLISECONDS, queue, this.threadFactory, (ManagedContextHandler)this.contextHandler);
        }
        return this.executor;
    }

    protected synchronized void shutdownExecutor() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    public Object $getResource(AbstractName moduleID) {
        return new ManagedExecutorServiceFacade(this.getManagedExecutorService(), false);
    }

    public void doStart() throws Exception {
    }

    public void doFail() {
        this.shutdownExecutor();
    }

    public void doStop() throws Exception {
        this.doFail();
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(ComponentManagedExecutorServiceGBean.class, (String)"ManagedExecutorService");
        infoFactory.addAttribute("classLoader", ClassLoader.class, false);
        infoFactory.addAttribute("minPoolSize", Integer.TYPE, true);
        infoFactory.addAttribute("maxPoolSize", Integer.TYPE, true);
        infoFactory.addAttribute("keepAliveTime", Long.TYPE, true);
        infoFactory.addAttribute("queueCapacity", Integer.TYPE, true);
        infoFactory.addAttribute("contextHandlers", String[].class, true);
        infoFactory.addReference("threadFactory", GeronimoManagedThreadFactorySource.class);
        infoFactory.setConstructor(new String[]{"classLoader", "minPoolSize", "maxPoolSize", "keepAliveTime", "queueCapacity", "threadFactory", "contextHandlers"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

