/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.concurrent.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.geronimo.concurrent.ManagedContext;
import org.apache.geronimo.concurrent.ManagedContextHandler;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelRegistry;
import org.apache.geronimo.kernel.lifecycle.LifecycleListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeronimoManagedContext
extends ManagedContext {
    private ModuleLifecycleListener moduleLifecyleListener;

    public GeronimoManagedContext(ManagedContextHandler contextHandler, Map<String, Object> capturedContext, AbstractName moduleName) {
        super(contextHandler, capturedContext);
        if (moduleName != null) {
            this.moduleLifecyleListener = ModuleLifecycleListener.getModuleLifecycleListener(moduleName);
        }
    }

    public boolean isValid() {
        return this.moduleLifecyleListener == null ? true : this.moduleLifecyleListener.isRunning();
    }

    private static class ModuleLifecycleListener
    implements LifecycleListener {
        private static Map<AbstractName, ModuleLifecycleListener> listeners = new HashMap<AbstractName, ModuleLifecycleListener>();
        private final AbstractName moduleName;
        private boolean running;

        public ModuleLifecycleListener(AbstractName moduleName) {
            this.moduleName = moduleName;
            this.running = true;
        }

        public boolean isRunning() {
            return this.running;
        }

        public AbstractName getModuleName() {
            return this.moduleName;
        }

        public void failed(AbstractName arg0) {
            this.running = false;
        }

        public void loaded(AbstractName arg0) {
            this.running = false;
        }

        public void running(AbstractName arg0) {
            this.running = true;
        }

        public void starting(AbstractName arg0) {
            this.running = false;
        }

        public void stopped(AbstractName arg0) {
            this.running = false;
        }

        public void stopping(AbstractName arg0) {
            this.running = false;
        }

        public void unloaded(AbstractName arg0) {
            this.running = false;
            ModuleLifecycleListener.removeModuleLifecycleListener(this.moduleName);
        }

        public static synchronized ModuleLifecycleListener getModuleLifecycleListener(AbstractName moduleName) {
            ModuleLifecycleListener listener = listeners.get(moduleName);
            if (listener == null) {
                listener = new ModuleLifecycleListener(moduleName);
                AbstractNameQuery query = new AbstractNameQuery(moduleName);
                Kernel kernel = KernelRegistry.getSingleKernel();
                kernel.getLifecycleMonitor().addLifecycleListener((LifecycleListener)listener, query);
                listeners.put(moduleName, listener);
            }
            return listener;
        }

        private static synchronized void removeModuleLifecycleListener(AbstractName moduleName) {
            listeners.remove(moduleName);
        }
    }
}

