/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.concurrent.impl.executor;

import java.util.List;
import javax.util.concurrent.ManagedScheduledExecutorService;
import javax.util.concurrent.ManagedThreadFactory;
import org.apache.geronimo.concurrent.ManagedContextHandler;
import org.apache.geronimo.concurrent.ManagedContextHandlerChain;
import org.apache.geronimo.concurrent.executor.ComponentManagedScheduledExecutorService;
import org.apache.geronimo.concurrent.executor.ManagedScheduledExecutorServiceFacade;
import org.apache.geronimo.concurrent.impl.ContextHandlerUtils;
import org.apache.geronimo.concurrent.impl.thread.GeronimoManagedThreadFactorySource;
import org.apache.geronimo.concurrent.naming.ModuleAwareResourceSource;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;

public class ComponentManagedScheduledExecutorServiceGBean
implements GBeanLifecycle,
ModuleAwareResourceSource {
    public static final GBeanInfo GBEAN_INFO;
    protected ManagedScheduledExecutorService executor;
    protected int corePoolSize;
    protected ManagedThreadFactory threadFactory;
    protected ManagedContextHandlerChain contextHandler;

    public ComponentManagedScheduledExecutorServiceGBean(ClassLoader classLoader, int corePoolSize, GeronimoManagedThreadFactorySource threadFactorySource, String[] contextHandlerClasses) {
        this.corePoolSize = corePoolSize;
        this.threadFactory = threadFactorySource.getManagedThreadFactory();
        List<ManagedContextHandler> handlers = ContextHandlerUtils.loadHandlers(classLoader, contextHandlerClasses);
        this.contextHandler = new ManagedContextHandlerChain(handlers);
    }

    protected synchronized ManagedScheduledExecutorService getManagedScheduledExecutorService() {
        if (this.executor == null) {
            this.executor = new ComponentManagedScheduledExecutorService(this.corePoolSize, this.threadFactory, (ManagedContextHandler)this.contextHandler);
        }
        return this.executor;
    }

    protected synchronized void shutdownExecutor() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    public Object $getResource(AbstractName moduleID) {
        return new ManagedScheduledExecutorServiceFacade(this.getManagedScheduledExecutorService(), false);
    }

    public void doStart() throws Exception {
    }

    public void doFail() {
        this.shutdownExecutor();
    }

    public void doStop() throws Exception {
        this.doFail();
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(ComponentManagedScheduledExecutorServiceGBean.class, (String)"ManagedExecutorService");
        infoFactory.addAttribute("classLoader", ClassLoader.class, false);
        infoFactory.addAttribute("corePoolSize", Integer.TYPE, true);
        infoFactory.addAttribute("contextHandlers", String[].class, true);
        infoFactory.addReference("threadFactory", GeronimoManagedThreadFactorySource.class);
        infoFactory.setConstructor(new String[]{"classLoader", "corePoolSize", "threadFactory", "contextHandlers"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

