/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.concurrent.impl.context;

import java.util.List;
import javax.util.concurrent.ContextService;
import org.apache.geronimo.concurrent.ManagedContextHandler;
import org.apache.geronimo.concurrent.ManagedContextHandlerChain;
import org.apache.geronimo.concurrent.context.BasicContextService;
import org.apache.geronimo.concurrent.impl.ContextHandlerUtils;
import org.apache.geronimo.concurrent.impl.context.ContextServiceModuleFacade;
import org.apache.geronimo.concurrent.naming.ModuleAwareResourceSource;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.Kernel;

public class ContextServiceGBean
implements ModuleAwareResourceSource {
    public static final GBeanInfo GBEAN_INFO;
    private ManagedContextHandlerChain mainContextHandler;
    private BasicContextService contextService;

    public ContextServiceGBean(Kernel kernel, ClassLoader classLoader, AbstractName name, String[] contextHandlerClasses) {
        List<ManagedContextHandler> handlers = ContextHandlerUtils.loadHandlers(classLoader, contextHandlerClasses);
        this.mainContextHandler = new ManagedContextHandlerChain(handlers);
    }

    private synchronized BasicContextService getContextService() {
        if (this.contextService == null) {
            this.contextService = new BasicContextService((ManagedContextHandler)this.mainContextHandler);
        }
        return this.contextService;
    }

    public Object $getResource(AbstractName moduleID) {
        return new ContextServiceModuleFacade((ContextService)this.getContextService(), moduleID);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(ContextServiceGBean.class, (String)"ContextService");
        infoFactory.addAttribute("classLoader", ClassLoader.class, false, false);
        infoFactory.addAttribute("abstractName", AbstractName.class, false, false);
        infoFactory.addAttribute("kernel", Kernel.class, false, false);
        infoFactory.addAttribute("contextHandlers", String[].class, true);
        infoFactory.setConstructor(new String[]{"kernel", "classLoader", "abstractName", "contextHandlers"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

