/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.clustering;

import java.io.IOException;
import java.util.HashMap;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.geronimo.clustering.Node;

public abstract class AbstractNode
implements Node {
    private final String name;

    public AbstractNode(String name) {
        if (null == name) {
            throw new IllegalArgumentException("name is required");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public JMXConnector getJMXConnector() throws IOException {
        HashMap<String, ClassLoader> environment = new HashMap<String, ClassLoader>();
        environment.put("jmx.remote.default.class.loader", AbstractNode.class.getClassLoader());
        JMXServiceURL address = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + this.getHost() + ":" + this.getPort() + "/JMXConnector");
        return JMXConnectorFactory.connect(address, environment);
    }

    protected abstract String getHost();

    protected abstract int getPort();

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractNode)) {
            return false;
        }
        AbstractNode other = (AbstractNode)obj;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

