/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.clustering.wadi;

import org.apache.geronimo.clustering.wadi.NodeService;
import org.codehaus.wadi.core.Lifecycle;
import org.codehaus.wadi.group.Dispatcher;
import org.codehaus.wadi.group.Peer;
import org.codehaus.wadi.servicespace.InvocationMetaData;
import org.codehaus.wadi.servicespace.ServiceAlreadyRegisteredException;
import org.codehaus.wadi.servicespace.ServiceProxyFactory;
import org.codehaus.wadi.servicespace.ServiceRegistry;
import org.codehaus.wadi.servicespace.ServiceSpace;
import org.codehaus.wadi.servicespace.admin.AdminServiceSpace;
import org.codehaus.wadi.servicespace.admin.AdminServiceSpaceHelper;

public class NodeServiceHelper {
    private final ServiceSpace serviceSpace;

    public NodeServiceHelper(Dispatcher dispatcher) {
        if (null == dispatcher) {
            throw new IllegalArgumentException("dispatcher is required");
        }
        this.serviceSpace = this.getAdminServiceSpace(dispatcher);
    }

    public NodeServiceHelper(ServiceSpace serviceSpace) {
        if (null == serviceSpace) {
            throw new IllegalArgumentException("serviceSpace is required");
        }
        this.serviceSpace = serviceSpace;
    }

    public void registerNodeService(NodeService nodeService) {
        ServiceRegistry serviceRegistry = this.serviceSpace.getServiceRegistry();
        try {
            serviceRegistry.register(NodeService.SERVICE_NAME, (Lifecycle)nodeService);
        }
        catch (ServiceAlreadyRegisteredException e) {
            throw new IllegalStateException("NodeService already registered.", e);
        }
    }

    public NodeService getNodeServiceProxy(Peer peer) {
        ServiceProxyFactory proxyFactory = this.serviceSpace.getServiceProxyFactory(NodeService.SERVICE_NAME, new Class[]{NodeService.class});
        InvocationMetaData invocationMetaData = proxyFactory.getInvocationMetaData();
        invocationMetaData.setTargets(new Peer[]{peer});
        return (NodeService)proxyFactory.getProxy();
    }

    protected ServiceSpace getAdminServiceSpace(Dispatcher dispatcher) {
        AdminServiceSpaceHelper helper = new AdminServiceSpaceHelper();
        AdminServiceSpace adminServiceSpace = helper.getAdminServiceSpace(dispatcher);
        return adminServiceSpace;
    }
}

