/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.clustering.wadi;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.clustering.Node;
import org.apache.geronimo.clustering.Session;
import org.apache.geronimo.clustering.SessionAlreadyExistException;
import org.apache.geronimo.clustering.SessionListener;
import org.apache.geronimo.clustering.SessionManager;
import org.apache.geronimo.clustering.wadi.RemoteNode;
import org.apache.geronimo.clustering.wadi.WADICluster;
import org.apache.geronimo.clustering.wadi.WADISessionAdaptor;
import org.apache.geronimo.clustering.wadi.WADISessionManager;
import org.apache.geronimo.clustering.wadi.WADISessionManagerConfigInfo;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.codehaus.wadi.core.assembler.StackContext;
import org.codehaus.wadi.core.manager.Manager;
import org.codehaus.wadi.core.manager.SessionMonitor;
import org.codehaus.wadi.group.Dispatcher;
import org.codehaus.wadi.group.Peer;
import org.codehaus.wadi.replication.strategy.BackingStrategyFactory;
import org.codehaus.wadi.servicespace.ServiceSpace;
import org.codehaus.wadi.servicespace.ServiceSpaceName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicWADISessionManager
implements GBeanLifecycle,
SessionManager,
WADISessionManager {
    private static final Log log = LogFactory.getLog(BasicWADISessionManager.class);
    private final ClassLoader cl;
    private final WADICluster cluster;
    private final WADISessionManagerConfigInfo configInfo;
    private final BackingStrategyFactory backingStrategyFactory;
    private final CopyOnWriteArrayList<SessionListener> listeners;
    private Manager manager;
    private SessionMonitor sessionMonitor;
    private ServiceSpace serviceSpace;
    public static final GBeanInfo GBEAN_INFO;
    public static final String GBEAN_ATTR_WADI_CONFIG_INFO = "wadiConfigInfo";
    public static final String GBEAN_REF_CLUSTER = "Cluster";
    public static final String GBEAN_REF_BACKING_STRATEGY_FACTORY = "BackingStrategyFactory";

    public BasicWADISessionManager(ClassLoader cl, WADISessionManagerConfigInfo configInfo, WADICluster cluster, BackingStrategyFactory backingStrategyFactory) {
        this.cl = cl;
        this.configInfo = configInfo;
        this.cluster = cluster;
        this.backingStrategyFactory = backingStrategyFactory;
        this.listeners = new CopyOnWriteArrayList();
    }

    public void doStart() throws Exception {
        Dispatcher underlyingDisp = this.cluster.getCluster().getDispatcher();
        ServiceSpaceName serviceSpaceName = new ServiceSpaceName(this.configInfo.getServiceSpaceURI());
        StackContext stackContext = new StackContext(this.cl, serviceSpaceName, underlyingDisp, this.configInfo.getSessionTimeoutSeconds(), this.configInfo.getNumPartitions(), this.configInfo.getSweepInterval(), this.backingStrategyFactory);
        stackContext.build();
        this.serviceSpace = stackContext.getServiceSpace();
        this.manager = stackContext.getManager();
        this.sessionMonitor = stackContext.getSessionMonitor();
        this.sessionMonitor.addSessionListener((org.codehaus.wadi.core.manager.SessionListener)new SessionListenerAdapter());
        this.serviceSpace.start();
    }

    public void doStop() throws Exception {
        this.serviceSpace.stop();
    }

    public void doFail() {
        try {
            this.serviceSpace.stop();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public Session createSession(String sessionId) throws SessionAlreadyExistException {
        org.codehaus.wadi.core.session.Session session;
        try {
            session = this.manager.createWithName(sessionId);
        }
        catch (org.codehaus.wadi.core.manager.SessionAlreadyExistException e) {
            throw new SessionAlreadyExistException("Session " + sessionId + " already exists", (Throwable)e);
        }
        return new WADISessionAdaptor(session);
    }

    @Override
    public Manager getManager() {
        return this.manager;
    }

    public Node getNode() {
        return this.cluster.getLocalNode();
    }

    public Set<Node> getRemoteNodes() {
        HashMap<Peer, RemoteNode> peerToRemoteNode = new HashMap<Peer, RemoteNode>();
        Set clusterNodes = this.cluster.getRemoteNodes();
        for (RemoteNode remoteNode : clusterNodes) {
            peerToRemoteNode.put(remoteNode.getPeer(), remoteNode);
        }
        HashSet<Node> nodes = new HashSet<Node>();
        Set peers = this.serviceSpace.getHostingPeers();
        for (Peer peer : peers) {
            RemoteNode remoteNode = (RemoteNode)((Object)peerToRemoteNode.get(peer));
            if (null == remoteNode) {
                throw new AssertionError((Object)"remoteNode is null");
            }
            nodes.add((Node)remoteNode);
        }
        return nodes;
    }

    public void registerListener(SessionListener listener) {
        this.listeners.add(listener);
    }

    public void unregisterListener(SessionListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyInboundSessionMigration(org.codehaus.wadi.core.session.Session session) {
        for (SessionListener listener : this.listeners) {
            listener.notifyInboundSessionMigration((Session)new WADISessionAdaptor(session));
        }
    }

    private void notifyOutboundSessionMigration(org.codehaus.wadi.core.session.Session session) {
        for (SessionListener listener : this.listeners) {
            listener.notifyOutboundSessionMigration((Session)new WADISessionAdaptor(session));
        }
    }

    private void notifySessionDestruction(org.codehaus.wadi.core.session.Session session) {
        for (SessionListener listener : this.listeners) {
            listener.notifySessionDestruction((Session)new WADISessionAdaptor(session));
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((String)"WADI Session Manager", BasicWADISessionManager.class, (String)"GBean");
        infoBuilder.addAttribute("classLoader", ClassLoader.class, false);
        infoBuilder.addAttribute(GBEAN_ATTR_WADI_CONFIG_INFO, WADISessionManagerConfigInfo.class, true);
        infoBuilder.addReference(GBEAN_REF_CLUSTER, WADICluster.class, "GBean");
        infoBuilder.addReference(GBEAN_REF_BACKING_STRATEGY_FACTORY, BackingStrategyFactory.class, "GBean");
        infoBuilder.addInterface(SessionManager.class);
        infoBuilder.addInterface(WADISessionManager.class);
        infoBuilder.setConstructor(new String[]{"classLoader", GBEAN_ATTR_WADI_CONFIG_INFO, GBEAN_REF_CLUSTER, GBEAN_REF_BACKING_STRATEGY_FACTORY});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }

    private class SessionListenerAdapter
    implements org.codehaus.wadi.core.manager.SessionListener {
        private SessionListenerAdapter() {
        }

        public void onSessionCreation(org.codehaus.wadi.core.session.Session session) {
        }

        public void onSessionDestruction(org.codehaus.wadi.core.session.Session session) {
            BasicWADISessionManager.this.notifySessionDestruction(session);
        }

        public void onInboundSessionMigration(org.codehaus.wadi.core.session.Session session) {
            BasicWADISessionManager.this.notifyInboundSessionMigration(session);
        }

        public void onOutbountSessionMigration(org.codehaus.wadi.core.session.Session session) {
            BasicWADISessionManager.this.notifyOutboundSessionMigration(session);
        }
    }
}

