/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.clustering.wadi;

import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.clustering.Node;
import org.apache.geronimo.clustering.wadi.DispatcherHolder;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.codehaus.wadi.group.Dispatcher;
import org.codehaus.wadi.group.EndPoint;
import org.codehaus.wadi.group.MessageExchangeException;
import org.codehaus.wadi.tribes.TribesDispatcher;
import org.codehaus.wadi.web.impl.URIEndPoint;

public class TribesDispatcherHolder
implements GBeanLifecycle,
DispatcherHolder {
    private static final Log log = LogFactory.getLog((Class)TribesDispatcherHolder.class);
    private final URI endPointURI;
    private final String clusterName;
    private final long inactiveTime;
    private final Node node;
    private TribesDispatcher dispatcher;
    public static final GBeanInfo GBEAN_INFO;
    public static final String GBEAN_ATTR_END_POINT_URI = "endPointURI";
    public static final String GBEAN_ATTR_CLUSTER_NAME = "clusterName";
    public static final String GBEAN_ATTR_CLUSTER_URI = "clusterUri";
    public static final String GBEAN_ATTR_INACTIVE_TIME = "inactiveTime";
    public static final String GBEAN_REF_NODE = "Node";

    public TribesDispatcherHolder(URI endPointURI, String clusterName, long inactiveTime, Node node) {
        if (null == endPointURI) {
            throw new IllegalArgumentException("endPointURI is required");
        }
        if (null == clusterName) {
            throw new IllegalArgumentException("clusterName is required");
        }
        if (0L > inactiveTime) {
            throw new IllegalArgumentException("inactiveTime must be > 0");
        }
        if (null == node) {
            throw new IllegalArgumentException("node is required");
        }
        this.endPointURI = endPointURI;
        this.clusterName = clusterName;
        this.inactiveTime = inactiveTime;
        this.node = node;
    }

    public void doStart() throws Exception {
        this.dispatcher = new TribesDispatcher(this.clusterName, this.node.getName(), (EndPoint)new URIEndPoint(this.endPointURI), this.inactiveTime, null);
        this.dispatcher.start();
    }

    public void doStop() throws Exception {
        this.dispatcher.stop();
    }

    public void doFail() {
        try {
            this.dispatcher.stop();
        }
        catch (MessageExchangeException e) {
            log.error((Object)e);
        }
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public Node getNode() {
        return this.node;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((Class)TribesDispatcherHolder.class, (String)"GBean");
        infoBuilder.addAttribute(GBEAN_ATTR_END_POINT_URI, URI.class, true);
        infoBuilder.addAttribute(GBEAN_ATTR_CLUSTER_NAME, String.class, true);
        infoBuilder.addAttribute(GBEAN_ATTR_INACTIVE_TIME, Long.TYPE, true);
        infoBuilder.addReference(GBEAN_REF_NODE, Node.class, "GBean");
        infoBuilder.addInterface(DispatcherHolder.class);
        infoBuilder.setConstructor(new String[]{GBEAN_ATTR_END_POINT_URI, GBEAN_ATTR_CLUSTER_NAME, GBEAN_ATTR_INACTIVE_TIME, GBEAN_REF_NODE});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

