/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.clustering.wadi;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.clustering.Node;
import org.apache.geronimo.clustering.Session;
import org.apache.geronimo.clustering.SessionAlreadyExistException;
import org.apache.geronimo.clustering.SessionListener;
import org.apache.geronimo.clustering.SessionManager;
import org.apache.geronimo.clustering.wadi.DispatcherHolder;
import org.apache.geronimo.clustering.wadi.WADISessionAdaptor;
import org.apache.geronimo.clustering.wadi.WADISessionManager;
import org.apache.geronimo.clustering.wadi.WADISessionManagerConfigInfo;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.codehaus.wadi.Collapser;
import org.codehaus.wadi.Contextualiser;
import org.codehaus.wadi.Emoter;
import org.codehaus.wadi.Evicter;
import org.codehaus.wadi.Immoter;
import org.codehaus.wadi.Invocation;
import org.codehaus.wadi.InvocationException;
import org.codehaus.wadi.InvocationProxy;
import org.codehaus.wadi.Lifecycle;
import org.codehaus.wadi.Manager;
import org.codehaus.wadi.ManagerConfig;
import org.codehaus.wadi.Motable;
import org.codehaus.wadi.PoolableInvocationWrapperPool;
import org.codehaus.wadi.Relocater;
import org.codehaus.wadi.ReplicaterFactory;
import org.codehaus.wadi.SessionPool;
import org.codehaus.wadi.Streamer;
import org.codehaus.wadi.ValueFactory;
import org.codehaus.wadi.ValuePool;
import org.codehaus.wadi.group.Dispatcher;
import org.codehaus.wadi.impl.AbsoluteEvicter;
import org.codehaus.wadi.impl.ClusterContextualiser;
import org.codehaus.wadi.impl.ClusteredManager;
import org.codehaus.wadi.impl.DummyContextualiser;
import org.codehaus.wadi.impl.HashingCollapser;
import org.codehaus.wadi.impl.HybridRelocater;
import org.codehaus.wadi.impl.MemoryContextualiser;
import org.codehaus.wadi.impl.SerialContextualiserFrontingMemory;
import org.codehaus.wadi.impl.SimpleSessionPool;
import org.codehaus.wadi.impl.SimpleStreamer;
import org.codehaus.wadi.impl.SimpleValuePool;
import org.codehaus.wadi.impl.StatelessContextualiser;
import org.codehaus.wadi.replication.contextualizer.ReplicaAwareContextualiser;
import org.codehaus.wadi.replication.manager.ReplicaterAdapterFactory;
import org.codehaus.wadi.replication.manager.ReplicationManager;
import org.codehaus.wadi.replication.manager.ReplicationManagerFactory;
import org.codehaus.wadi.replication.manager.basic.SessionReplicationManager;
import org.codehaus.wadi.replication.storage.ReplicaStorage;
import org.codehaus.wadi.replication.storage.ReplicaStorageFactory;
import org.codehaus.wadi.replication.strategy.BackingStrategyFactory;
import org.codehaus.wadi.servicespace.ServiceRegistry;
import org.codehaus.wadi.servicespace.ServiceSpace;
import org.codehaus.wadi.servicespace.ServiceSpaceName;
import org.codehaus.wadi.servicespace.basic.BasicServiceSpace;
import org.codehaus.wadi.web.AttributesFactory;
import org.codehaus.wadi.web.Router;
import org.codehaus.wadi.web.WebSession;
import org.codehaus.wadi.web.WebSessionFactory;
import org.codehaus.wadi.web.WebSessionPool;
import org.codehaus.wadi.web.WebSessionWrapperFactory;
import org.codehaus.wadi.web.impl.AtomicallyReplicableSessionFactory;
import org.codehaus.wadi.web.impl.DistributableAttributesFactory;
import org.codehaus.wadi.web.impl.DistributableValueFactory;
import org.codehaus.wadi.web.impl.DummyRouter;
import org.codehaus.wadi.web.impl.DummyStatefulHttpServletRequestWrapperPool;
import org.codehaus.wadi.web.impl.StandardHttpProxy;
import org.codehaus.wadi.web.impl.StandardSessionWrapperFactory;
import org.codehaus.wadi.web.impl.WebSessionToSessionPoolAdapter;

public class BasicWADISessionManager
implements GBeanLifecycle,
SessionManager,
WADISessionManager {
    private static final Log log = LogFactory.getLog((Class)BasicWADISessionManager.class);
    private final WADISessionManagerConfigInfo configInfo;
    private final ReplicationManagerFactory repManagerFactory;
    private final ReplicaStorageFactory repStorageFactory;
    private final BackingStrategyFactory backingStrategyFactory;
    private final DispatcherHolder dispatcherHolder;
    private final CopyOnWriteArrayList listeners;
    private ClusteredManager manager;
    private BasicServiceSpace serviceSpace;
    public static final GBeanInfo GBEAN_INFO;
    public static final String GBEAN_ATTR_WADI_CONFIG_INFO = "wadiConfigInfo";
    public static final String GBEAN_REF_REPLICATION_MANAGER_FACTORY = "ReplicationManagerFactory";
    public static final String GBEAN_REF_REPLICA_STORAGE_FACTORY = "ReplicaStorageFactory";
    public static final String GBEAN_REF_BACKING_STRATEGY_FACTORY = "BackingStrategyFactory";
    public static final String GBEAN_REF_DISPATCHER_HOLDER = "DispatcherHolder";

    public BasicWADISessionManager(WADISessionManagerConfigInfo configInfo, ReplicationManagerFactory repManagerFactory, ReplicaStorageFactory repStorageFactory, BackingStrategyFactory backingStrategyFactory, DispatcherHolder dispatcherHolder) {
        this.configInfo = configInfo;
        this.dispatcherHolder = dispatcherHolder;
        this.repManagerFactory = repManagerFactory;
        this.repStorageFactory = repStorageFactory;
        this.backingStrategyFactory = backingStrategyFactory;
        this.listeners = new CopyOnWriteArrayList();
    }

    public void doStart() throws Exception {
        Dispatcher underlyingDisp = this.dispatcherHolder.getDispatcher();
        this.serviceSpace = new BasicServiceSpace(new ServiceSpaceName(this.configInfo.getServiceSpaceURI()), underlyingDisp);
        boolean strictOrdering = true;
        SimpleStreamer streamer = new SimpleStreamer();
        HashingCollapser collapser = new HashingCollapser(1024, 10000L);
        Map mmap = Collections.synchronizedMap(new HashMap());
        SimpleSessionPool sessionPool = new SimpleSessionPool((WebSessionFactory)new AtomicallyReplicableSessionFactory());
        Object contextualiser = new DummyContextualiser();
        ReplicationManager replicationManager = this.repManagerFactory.factory((ServiceSpace)this.serviceSpace, this.backingStrategyFactory);
        SessionReplicationManager sessionRepManager = new SessionReplicationManager(replicationManager, (WebSessionPool)sessionPool);
        contextualiser = new ReplicaAwareContextualiser((Contextualiser)contextualiser, (ReplicationManager)sessionRepManager);
        contextualiser = new ClusterContextualiser((Contextualiser)contextualiser, (Collapser)collapser, (Relocater)new HybridRelocater(5000L, 5000L, true));
        contextualiser = new StatelessContextualiser((Contextualiser)contextualiser, Pattern.compile("GET|POST", 2), true, Pattern.compile(".*\\.(JPG|JPEG|GIF|PNG|ICO|HTML|HTM)", 2), false);
        AbsoluteEvicter mevicter = new AbsoluteEvicter(this.configInfo.getSweepInterval(), strictOrdering, this.configInfo.getSessionTimeoutSeconds());
        WebSessionToSessionPoolAdapter contextPool = new WebSessionToSessionPoolAdapter((WebSessionPool)sessionPool);
        DummyStatefulHttpServletRequestWrapperPool requestPool = new DummyStatefulHttpServletRequestWrapperPool();
        contextualiser = new MotionTracker((Contextualiser)contextualiser, (Evicter)mevicter, mmap, (Streamer)streamer, (SessionPool)contextPool, (PoolableInvocationWrapperPool)requestPool);
        contextualiser = new SerialContextualiserFrontingMemory((Contextualiser)contextualiser, (Collapser)collapser);
        this.manager = new ClusteredManager((WebSessionPool)sessionPool, (AttributesFactory)new DistributableAttributesFactory(), (ValuePool)new SimpleValuePool((ValueFactory)new DistributableValueFactory()), (WebSessionWrapperFactory)new StandardSessionWrapperFactory(), null, (Contextualiser)contextualiser, mmap, (Router)new DummyRouter(), false, (Streamer)streamer, true, (ReplicaterFactory)new ReplicaterAdapterFactory(replicationManager, (WebSessionPool)sessionPool), (InvocationProxy)new StandardHttpProxy("jsessionid"), (ServiceSpace)this.serviceSpace, this.configInfo.getNumPartitions(), (Collapser)collapser);
        this.manager.init(new ManagerConfig(){

            public void callback(Manager manager) {
            }

            public ServletContext getServletContext() {
                return null;
            }
        });
        ServiceRegistry serviceRegistry = this.serviceSpace.getServiceRegistry();
        serviceRegistry.register(ReplicaStorage.NAME, (Lifecycle)this.repStorageFactory.factory((ServiceSpace)this.serviceSpace));
        serviceRegistry.register(ReplicationManager.NAME, (Lifecycle)replicationManager);
        serviceRegistry.register(ClusteredManager.NAME, (Lifecycle)this.manager);
        this.serviceSpace.start();
    }

    public void doStop() throws Exception {
        this.serviceSpace.stop();
    }

    public void doFail() {
        try {
            this.serviceSpace.stop();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public Session createSession(String sessionId) throws SessionAlreadyExistException {
        WebSession session;
        try {
            session = this.manager.createWithName(sessionId);
        }
        catch (org.codehaus.wadi.SessionAlreadyExistException e) {
            throw new SessionAlreadyExistException(sessionId);
        }
        return new WADISessionAdaptor(session);
    }

    public ClusteredManager getManager() {
        return this.manager;
    }

    public Node getNode() {
        return this.dispatcherHolder.getNode();
    }

    public void registerListener(SessionListener listener) {
        this.listeners.add((Object)listener);
    }

    public void unregisterListener(SessionListener listener) {
        this.listeners.remove((Object)listener);
    }

    private void notifyInboundSessionMigration(WebSession webSession) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            SessionListener listener = (SessionListener)iter.next();
            listener.notifyInboundSessionMigration((Session)new WADISessionAdaptor(webSession));
        }
    }

    private WebSession notifyOutboundSessionMigration(WebSession webSession) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            SessionListener listener = (SessionListener)iter.next();
            listener.notifyOutboundSessionMigration((Session)new WADISessionAdaptor(webSession));
        }
        return webSession;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((String)"WADI Session Manager", (Class)BasicWADISessionManager.class, (String)"GBean");
        infoBuilder.addAttribute(GBEAN_ATTR_WADI_CONFIG_INFO, WADISessionManagerConfigInfo.class, true);
        infoBuilder.addReference(GBEAN_REF_REPLICATION_MANAGER_FACTORY, ReplicationManagerFactory.class, "GBean");
        infoBuilder.addReference(GBEAN_REF_REPLICA_STORAGE_FACTORY, ReplicaStorageFactory.class, "GBean");
        infoBuilder.addReference(GBEAN_REF_BACKING_STRATEGY_FACTORY, BackingStrategyFactory.class, "GBean");
        infoBuilder.addReference(GBEAN_REF_DISPATCHER_HOLDER, DispatcherHolder.class, "GBean");
        infoBuilder.addInterface(SessionManager.class);
        infoBuilder.addInterface(WADISessionManager.class);
        infoBuilder.setConstructor(new String[]{GBEAN_ATTR_WADI_CONFIG_INFO, GBEAN_REF_REPLICATION_MANAGER_FACTORY, GBEAN_REF_REPLICA_STORAGE_FACTORY, GBEAN_REF_BACKING_STRATEGY_FACTORY, GBEAN_REF_DISPATCHER_HOLDER});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }

    private class InboundSessionTracker
    implements Immoter {
        private final Immoter delegate;

        public InboundSessionTracker(Immoter delegate) {
            this.delegate = delegate;
        }

        public void commit(String arg0, Motable arg1) {
            BasicWADISessionManager.this.notifyInboundSessionMigration((WebSession)arg1);
            this.delegate.commit(arg0, arg1);
        }

        public boolean contextualise(Invocation arg0, String arg1, Motable arg2, Sync arg3) throws InvocationException {
            return this.delegate.contextualise(arg0, arg1, arg2, arg3);
        }

        public String getInfo() {
            return this.delegate.getInfo();
        }

        public Motable nextMotable(String arg0, Motable arg1) {
            return this.delegate.nextMotable(arg0, arg1);
        }

        public boolean prepare(String arg0, Motable arg1, Motable arg2) {
            return this.delegate.prepare(arg0, arg1, arg2);
        }

        public void rollback(String arg0, Motable arg1) {
            this.delegate.rollback(arg0, arg1);
        }
    }

    private class OutboundSessionTracker
    implements Emoter {
        private final Emoter delegate;

        public OutboundSessionTracker(Emoter delegate) {
            this.delegate = delegate;
        }

        public void commit(String arg0, Motable arg1) {
            BasicWADISessionManager.this.notifyOutboundSessionMigration((WebSession)arg1);
            this.delegate.commit(arg0, arg1);
        }

        public String getInfo() {
            return this.delegate.getInfo();
        }

        public boolean prepare(String arg0, Motable arg1, Motable arg2) {
            return this.delegate.prepare(arg0, arg1, arg2);
        }

        public void rollback(String arg0, Motable arg1) {
            this.delegate.rollback(arg0, arg1);
        }
    }

    private class MotionTracker
    extends MemoryContextualiser {
        private final Immoter immoter;
        private final Emoter emoter;

        public MotionTracker(Contextualiser next, Evicter evicter, Map map, Streamer streamer, SessionPool pool, PoolableInvocationWrapperPool requestPool) {
            super(next, evicter, map, streamer, pool, requestPool);
            Immoter immoterDelegate = super.getImmoter();
            this.immoter = new InboundSessionTracker(immoterDelegate);
            Emoter emoterDelegate = super.getEmoter();
            this.emoter = new OutboundSessionTracker(emoterDelegate);
        }

        public Immoter getPromoter(Immoter immoter) {
            Immoter delegate = super.getPromoter(immoter);
            if (null == immoter) {
                return new InboundSessionTracker(delegate);
            }
            return delegate;
        }

        public Immoter getImmoter() {
            return this.immoter;
        }

        public Emoter getEmoter() {
            return this.emoter;
        }
    }
}

