/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cli;

import java.io.PrintStream;
import org.apache.geronimo.cli.CLParser;
import org.apache.geronimo.cli.CLParserException;
import org.apache.geronimo.kernel.log.GeronimoLogging;
import org.apache.geronimo.kernel.util.MainConfigurationBootstrapper;

public abstract class AbstractCLI {
    private final String[] args;
    private final PrintStream errStream;

    protected AbstractCLI(String[] args, PrintStream errStream) {
        if (null == args) {
            throw new IllegalArgumentException("args is required");
        }
        if (null == errStream) {
            throw new IllegalArgumentException("errStream is required");
        }
        this.args = args;
        this.errStream = errStream;
    }

    public int executeMain() {
        CLParser parser = this.getCLParser();
        try {
            parser.parse(this.args);
        }
        catch (CLParserException e) {
            this.errStream.println(e.getMessage());
            parser.displayHelp();
            return 1;
        }
        if (parser.isHelp()) {
            parser.displayHelp();
            return 0;
        }
        boolean executed = this.executeCommand(parser);
        if (executed) {
            return 0;
        }
        this.initializeLogging(parser);
        MainConfigurationBootstrapper mainConfigurationBootstrapper = this.newMainConfigurationBootstrapper();
        return MainConfigurationBootstrapper.main((MainConfigurationBootstrapper)mainConfigurationBootstrapper, (Object)parser);
    }

    protected boolean executeCommand(CLParser parser) {
        return false;
    }

    protected void initializeLogging(CLParser parser) {
        GeronimoLogging level = GeronimoLogging.WARN;
        if (parser.isVerboseInfo()) {
            level = GeronimoLogging.INFO;
        } else if (parser.isVerboseDebug()) {
            level = GeronimoLogging.DEBUG;
        } else if (parser.isVerboseTrace()) {
            level = GeronimoLogging.TRACE;
        }
        GeronimoLogging.initialize((GeronimoLogging)level);
    }

    protected abstract MainConfigurationBootstrapper newMainConfigurationBootstrapper();

    protected abstract CLParser getCLParser();
}

