/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.bval;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.bval.jsr303.ConfigurationImpl;
import org.apache.bval.jsr303.xml.PropertyType;
import org.apache.bval.jsr303.xml.ValidationConfigType;
import org.apache.bval.jsr303.xml.ValidationParser;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.OsgiService;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.kernel.util.FileUtils;
import org.apache.geronimo.kernel.util.IOUtils;
import org.apache.geronimo.naming.ResourceSource;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@GBean(j2eeType="ValidatorFactory")
@OsgiService
public class ValidatorFactoryGBean
implements GBeanLifecycle,
ResourceSource<ValidationException> {
    private static final Logger log = LoggerFactory.getLogger(ValidatorFactoryGBean.class);
    private static final JAXBContext VALIDATION_FACTORY_CONTEXT;
    private static final Schema VALIDATION_FACTORY_SCHEMA;
    private final String objectName;
    private final Bundle bundle;
    private final ClassLoader classLoader;
    private final String moduleName;
    private String validationConfig;
    private ValidatorFactory factory;
    private File tmpArchiveFile;

    public ValidatorFactoryGBean(@ParamSpecial(type=SpecialAttributeType.objectName) String objectName, @ParamSpecial(type=SpecialAttributeType.bundle) Bundle bundle, @ParamSpecial(type=SpecialAttributeType.classLoader) ClassLoader classLoader, @ParamAttribute(name="moduleName") String moduleName, @ParamAttribute(name="validationConfig") String validationConfig) {
        this.objectName = objectName;
        this.bundle = bundle;
        this.classLoader = classLoader;
        this.moduleName = moduleName;
        this.validationConfig = validationConfig;
    }

    public Object $getResource() throws ValidationException {
        return this.getFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidatorFactory getFactory() {
        if (this.factory == null) {
            if (this.validationConfig == null) {
                this.createDefaultFactory();
            } else {
                ValidationConfigType validationConfigType = null;
                try {
                    Unmarshaller unmarshaller = VALIDATION_FACTORY_CONTEXT.createUnmarshaller();
                    unmarshaller.setSchema(VALIDATION_FACTORY_SCHEMA);
                    URL validationConfigURL = null;
                    if (this.moduleName == null) {
                        validationConfigURL = this.bundle.getEntry(this.validationConfig);
                    } else if (this.bundle.getEntry(this.moduleName + "/" + this.validationConfig) != null) {
                        validationConfigURL = this.bundle.getEntry(this.moduleName + "/" + this.validationConfig);
                    } else {
                        try {
                            this.tmpArchiveFile = FileUtils.createTempFile((String)".jar");
                            InputStream inp = this.bundle.getEntry(this.moduleName).openStream();
                            FileOutputStream out = new FileOutputStream(this.tmpArchiveFile);
                            IOUtils.copy((InputStream)inp, (OutputStream)out);
                            inp.close();
                            ((OutputStream)out).close();
                            validationConfigURL = new URL("jar:" + this.tmpArchiveFile.toURI().toURL() + "!/" + this.validationConfig);
                        }
                        catch (IOException e) {
                            log.warn("Error processing validation configuration " + this.validationConfig + " in " + this.moduleName + " Using default factory.", (Throwable)e);
                            this.createDefaultFactory();
                            return this.factory;
                        }
                    }
                    StreamSource stream = new StreamSource(validationConfigURL.openStream());
                    JAXBElement root = unmarshaller.unmarshal((Source)stream, ValidationConfigType.class);
                    validationConfigType = (ValidationConfigType)root.getValue();
                }
                catch (Throwable t) {
                    log.warn("Unable to create module ValidatorFactory instance.  Using default factory", t);
                    this.createDefaultFactory();
                    return this.factory;
                }
                ConfigurationImpl config = (ConfigurationImpl)Validation.byDefaultProvider().configure();
                this.applyConfig(validationConfigType, config);
                config.ignoreXmlConfiguration();
                ClassLoader oldContextLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.classLoader);
                    this.factory = config.buildValidatorFactory();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldContextLoader);
                }
                if (this.tmpArchiveFile != null) {
                    this.tmpArchiveFile.delete();
                }
            }
        }
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDefaultFactory() {
        ClassLoader oldContextLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(null);
            this.factory = Validation.buildDefaultValidatorFactory();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextLoader);
        }
    }

    private void applyConfig(ValidationConfigType xmlConfig, ConfigurationImpl target) {
        String providerClassName = xmlConfig.getDefaultProvider();
        if (providerClassName != null) {
            try {
                Class<?> clazz = this.classLoader.loadClass(providerClassName);
                target.setProviderClass(clazz);
                log.info("Using " + providerClassName + " as validation provider.");
            }
            catch (ClassNotFoundException e) {
                log.warn("Unable to load provider class " + providerClassName, (Throwable)e);
            }
        }
        String messageInterpolatorClass = xmlConfig.getMessageInterpolator();
        if (target.getMessageInterpolator() == null && messageInterpolatorClass != null) {
            try {
                Class<?> clazz = this.classLoader.loadClass(messageInterpolatorClass);
                target.messageInterpolator((MessageInterpolator)clazz.newInstance());
            }
            catch (Exception e) {
                log.warn("Unable to set " + messageInterpolatorClass + " as message interpolator.", (Throwable)e);
            }
            log.info("Using " + messageInterpolatorClass + " as message interpolator.");
        }
        String traversableResolverClass = xmlConfig.getTraversableResolver();
        if (target.getTraversableResolver() == null && traversableResolverClass != null) {
            try {
                Class<?> clazz = this.classLoader.loadClass(traversableResolverClass);
                target.traversableResolver((TraversableResolver)clazz.newInstance());
            }
            catch (Exception e) {
                log.warn("Unable to set " + traversableResolverClass + " as traversable resolver.", (Throwable)e);
            }
            log.info("Using " + traversableResolverClass + " as traversable resolver.");
        }
        String constraintFactoryClass = xmlConfig.getConstraintValidatorFactory();
        if (target.getConstraintValidatorFactory() == null && constraintFactoryClass != null) {
            try {
                Class<?> clazz = this.classLoader.loadClass(constraintFactoryClass);
                target.constraintValidatorFactory((ConstraintValidatorFactory)clazz.newInstance());
            }
            catch (Exception e) {
                log.warn("Unable to set " + constraintFactoryClass + " as constraint factory.", (Throwable)e);
            }
            log.info("Using " + constraintFactoryClass + " as constraint factory.");
        }
        for (PropertyType property : xmlConfig.getProperty()) {
            if (log.isDebugEnabled()) {
                log.debug("Found property '" + property.getName() + "' with value '" + property.getValue() + "' in " + this.validationConfig);
            }
            target.addProperty(property.getName(), property.getValue());
        }
        for (JAXBElement mappingFileNameElement : xmlConfig.getConstraintMapping()) {
            String mappingFileName = (String)mappingFileNameElement.getValue();
            if (log.isDebugEnabled()) {
                log.debug("Opening input stream for " + mappingFileName);
            }
            InputStream in = null;
            try {
                in = this.moduleName == null ? this.bundle.getEntry(mappingFileName).openStream() : (this.tmpArchiveFile != null ? new URL("jar:" + this.tmpArchiveFile.toURI().toURL() + "!/" + mappingFileName).openStream() : this.bundle.getEntry(this.moduleName + "/" + mappingFileName).openStream());
                if (in == null) {
                    throw new ValidationException("Unable to open input stream for mapping file " + mappingFileName + (this.moduleName != null ? " in " + this.moduleName : ""));
                }
            }
            catch (IOException e) {
                throw new ValidationException("Unable to open input stream for mapping file " + mappingFileName + (this.moduleName != null ? " in " + this.moduleName : ""), (Throwable)e);
            }
            target.addMapping(in);
        }
    }

    public void doStart() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Starting " + this.objectName);
        }
        if (this.validationConfig != null) {
            this.getFactory();
        }
    }

    public void doStop() throws Exception {
        this.factory = null;
        if (log.isDebugEnabled()) {
            log.debug("Stopped " + this.objectName);
        }
    }

    public void doFail() {
        this.factory = null;
        log.warn("Failed " + this.objectName);
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return false;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return false;
    }

    static {
        URL schemaUrl = ValidationParser.class.getClassLoader().getResource("META-INF/validation-configuration-1.0.xsd");
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            VALIDATION_FACTORY_SCHEMA = sf.newSchema(schemaUrl);
            VALIDATION_FACTORY_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{ValidationConfigType.class});
        }
        catch (SAXException e) {
            throw new RuntimeException("Fail to initialize the schema instance", e);
        }
        catch (JAXBException e) {
            throw new RuntimeException("Fail to initialize the JAXB context instance", e);
        }
    }
}

