/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis2.osgi;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.ModuleBuilder;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.Version;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.modules.Module;
import org.apache.axis2.osgi.deployment.BundleClassLoader;
import org.apache.axis2.osgi.deployment.Registry;
import org.apache.axis2.util.Utils;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.OsgiService;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean
@OsgiService
public class Axis2ModuleRegistry
implements BundleListener,
GBeanLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(Axis2ModuleRegistry.class);
    private BundleContext bundleContext;
    private final Map<Bundle, List<URL>> bundleModuleXmlURLsMap = new ConcurrentHashMap<Bundle, List<URL>>();

    public Axis2ModuleRegistry(@ParamSpecial(type=SpecialAttributeType.bundleContext) BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        int bundleState = bundle.getState();
        if (bundleState == 32) {
            this.addModuleXmlBundle(bundle);
        } else if (bundleState == 16) {
            this.bundleModuleXmlURLsMap.remove(bundle);
        }
    }

    public void doStart() throws Exception {
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (bundle.getState() != 32) continue;
            this.addModuleXmlBundle(bundle);
        }
        this.bundleContext.addBundleListener((BundleListener)this);
    }

    public void doStop() throws Exception {
        this.bundleContext.removeBundleListener((BundleListener)this);
        this.bundleModuleXmlURLsMap.clear();
    }

    public Map<Bundle, List<URL>> getBundleModuleXmlURLsMap() {
        return new HashMap<Bundle, List<URL>>(this.bundleModuleXmlURLsMap);
    }

    private void addModuleXmlBundle(Bundle bundle) {
        Enumeration enumeration = bundle.findEntries("META-INF", "*module.xml", false);
        if (enumeration == null) {
            return;
        }
        ArrayList moduleXmls = new ArrayList();
        while (enumeration.hasMoreElements()) {
            moduleXmls.add(enumeration.nextElement());
        }
        this.bundleModuleXmlURLsMap.put(bundle, moduleXmls);
    }

    public void configureModules(ConfigurationContext configurationContext) {
        for (Map.Entry<Bundle, List<URL>> entry : this.bundleModuleXmlURLsMap.entrySet()) {
            Bundle bundle = entry.getKey();
            for (URL url : entry.getValue()) {
                try {
                    String bundleVersion;
                    AxisModule axismodule = new AxisModule();
                    BundleClassLoader loader = new BundleClassLoader(bundle, Registry.class.getClassLoader());
                    axismodule.setModuleClassLoader((ClassLoader)loader);
                    AxisConfiguration axisConfig = configurationContext.getAxisConfiguration();
                    ModuleBuilder builder = new ModuleBuilder(url.openStream(), axismodule, axisConfig);
                    Dictionary headers = bundle.getHeaders();
                    String bundleSymbolicName = (String)headers.get("Bundle-SymbolicName");
                    if (bundleSymbolicName != null && bundleSymbolicName.length() != 0) {
                        axismodule.setName(bundleSymbolicName);
                    }
                    if ((bundleVersion = (String)headers.get("Bundle-Version")) != null && bundleVersion.length() != 0) {
                        String[] versionSplit = bundleVersion.split("\\.");
                        int[] components = new int[Math.min(versionSplit.length, 3)];
                        for (int i = 0; i < components.length; ++i) {
                            components[i] = Integer.parseInt(versionSplit[i]);
                        }
                        axismodule.setVersion(new Version(components, versionSplit.length > 3 ? versionSplit[3] : null));
                    }
                    builder.populateModule();
                    axismodule.setParent(axisConfig);
                    AxisModule module = axisConfig.getModule(axismodule.getName());
                    if (module == null) {
                        DeploymentEngine.addNewModule((AxisModule)axismodule, (AxisConfiguration)axisConfig);
                        Module moduleObj = axismodule.getModule();
                        if (moduleObj != null) {
                            moduleObj.init(configurationContext, axismodule);
                        }
                    }
                    Utils.calculateDefaultModuleVersion((HashMap)axisConfig.getModules(), (AxisConfiguration)axisConfig);
                }
                catch (IOException e) {
                    logger.error("Error while reading module.xml", (Throwable)e);
                }
            }
        }
    }
}

