/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis.client;

import java.net.URL;
import java.rmi.RemoteException;
import java.util.Enumeration;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.NoEndPointException;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;

public class GenericServiceEndpoint
extends Stub {
    public GenericServiceEndpoint(QName portQName, Service service, URL location) {
        this.service = service;
        this.cachedEndpoint = location;
        this.cachedPortName = portQName;
    }

    Call createCall() throws RemoteException {
        try {
            Call _call = (Call)this.service.createCall();
            if (this.maintainSessionSet) {
                _call.setMaintainSession(this.maintainSession);
            }
            if (this.cachedUsername != null) {
                _call.setUsername(this.cachedUsername);
            }
            if (this.cachedPassword != null) {
                _call.setPassword(this.cachedPassword);
            }
            if (this.cachedEndpoint != null) {
                _call.setTargetEndpointAddress(this.cachedEndpoint);
            }
            if (this.cachedTimeout != null) {
                _call.setTimeout(this.cachedTimeout);
            }
            if (this.cachedPortName != null) {
                _call.setPortName(this.cachedPortName);
            }
            Enumeration<Object> keys = this.cachedProperties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                _call.setProperty(key, this.cachedProperties.get(key));
            }
            return _call;
        }
        catch (Throwable t) {
            throw new AxisFault("Failure trying to get the Call object", t);
        }
    }

    void checkCachedEndpoint() throws NoEndPointException {
        if (this.cachedEndpoint == null) {
            throw new NoEndPointException();
        }
    }

    void setUpCall(Call call) throws AxisFault {
        this.setRequestHeaders(call);
        this.setAttachments(call);
    }
}

