/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis.server;

import java.net.URI;
import org.apache.axis.Handler;
import org.apache.axis.description.JavaServiceDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.geronimo.axis.server.AxisWebServiceContainer;
import org.apache.geronimo.axis.server.ServiceInfo;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.openejb.EjbDeployment;
import org.apache.geronimo.webservices.SoapHandler;
import org.apache.geronimo.webservices.WebServiceContainer;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.server.axis.EjbContainerProvider;

public class EjbWebServiceGBean
implements GBeanLifecycle {
    private final SoapHandler soapHandler;
    private final URI location;
    public static final GBeanInfo GBEAN_INFO;

    protected EjbWebServiceGBean() {
        this.soapHandler = null;
        this.location = null;
    }

    public EjbWebServiceGBean(EjbDeployment ejbDeploymentContext, URI location, URI wsdlURI, SoapHandler soapHandler, ServiceInfo serviceInfo, String securityRealmName, String realmName, String transportGuarantee, String authMethod, String[] virtualHosts) throws Exception {
        this.soapHandler = soapHandler;
        this.location = location;
        if (ejbDeploymentContext == null) {
            return;
        }
        EjbContainerProvider provider = new EjbContainerProvider((DeploymentInfo)ejbDeploymentContext.getDeploymentInfo(), serviceInfo.getHandlerInfos());
        SOAPService service = new SOAPService(null, (Handler)provider, null);
        JavaServiceDesc serviceDesc = serviceInfo.getServiceDesc();
        service.setServiceDescription((ServiceDesc)serviceDesc);
        ClassLoader classLoader = ejbDeploymentContext.getClassLoader();
        Class<?> serviceEndpointInterface = classLoader.loadClass(ejbDeploymentContext.getServiceEndpointInterfaceName());
        service.setOption("className", (Object)serviceEndpointInterface.getName());
        serviceDesc.setImplClass(serviceEndpointInterface);
        AxisWebServiceContainer axisContainer = new AxisWebServiceContainer(location, wsdlURI, service, serviceInfo.getWsdlMap(), classLoader);
        if (soapHandler != null) {
            soapHandler.addWebService(location.getPath(), virtualHosts, (WebServiceContainer)axisContainer, securityRealmName, realmName, transportGuarantee, authMethod, classLoader);
        }
    }

    public void doStart() throws Exception {
    }

    public void doStop() throws Exception {
        if (this.soapHandler != null) {
            this.soapHandler.removeWebService(this.location.getPath());
        }
    }

    public void doFail() {
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(EjbWebServiceGBean.class, EjbWebServiceGBean.class, (String)"WSLink");
        infoFactory.addReference("EjbDeployment", EjbDeployment.class);
        infoFactory.addAttribute("location", URI.class, true);
        infoFactory.addAttribute("wsdlURI", URI.class, true);
        infoFactory.addAttribute("securityRealmName", String.class, true);
        infoFactory.addAttribute("realmName", String.class, true);
        infoFactory.addAttribute("transportGuarantee", String.class, true);
        infoFactory.addAttribute("authMethod", String.class, true);
        infoFactory.addAttribute("serviceInfo", ServiceInfo.class, true);
        infoFactory.addAttribute("virtualHosts", String[].class, true);
        infoFactory.addReference("WebServiceContainer", SoapHandler.class);
        infoFactory.setConstructor(new String[]{"EjbDeployment", "location", "wsdlURI", "WebServiceContainer", "serviceInfo", "securityRealmName", "realmName", "transportGuarantee", "authMethod", "virtualHosts"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

