/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.aries;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.aries.application.ApplicationMetadata;
import org.apache.aries.application.ApplicationMetadataFactory;
import org.apache.aries.application.DeploymentMetadata;
import org.apache.aries.application.DeploymentMetadataFactory;
import org.apache.aries.application.management.AriesApplication;
import org.apache.aries.application.management.BundleInfo;
import org.apache.aries.application.utils.filesystem.IOUtils;
import org.apache.aries.application.utils.management.SimpleBundleInfo;
import org.apache.aries.application.utils.manifest.BundleManifest;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.osgi.framework.Bundle;

public class GeronimoApplication
implements AriesApplication {
    private final ApplicationMetadata applicationMetadata;
    private final Set<BundleInfo> bundleInfo;
    private DeploymentMetadata deploymentMetadata;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeronimoApplication(Bundle bundle, ApplicationMetadataFactory applicationFactory, DeploymentMetadataFactory deploymentFactory) throws IOException {
        URL applicationMF = bundle.getEntry("META-INF/APPLICATION.MF");
        InputStream applicationMFStream = null;
        try {
            applicationMFStream = applicationMF.openStream();
            this.applicationMetadata = applicationFactory.parseApplicationMetadata(applicationMFStream);
        }
        finally {
            IOUtils.close((Closeable)applicationMFStream);
        }
        this.bundleInfo = new HashSet<BundleInfo>();
        File bundleFile = BundleUtils.toFile((Bundle)bundle);
        if (bundleFile != null && bundleFile.isDirectory()) {
            this.collectFileSystemBasedBundleInfos(bundleFile, applicationFactory);
        } else {
            this.collectBundleEntryBasedBundleInfos(bundle, applicationFactory);
        }
        URL deploymentMF = bundle.getEntry("META-INF/DEPLOYMENT.MF");
        if (deploymentMF != null) {
            InputStream deploymentMFStream = null;
            try {
                deploymentMFStream = deploymentMF.openStream();
                this.deploymentMetadata = deploymentFactory.createDeploymentMetadata(deploymentMFStream);
            }
            finally {
                IOUtils.close((Closeable)deploymentMFStream);
            }
        }
    }

    public ApplicationMetadata getApplicationMetadata() {
        return this.applicationMetadata;
    }

    public Set<BundleInfo> getBundleInfo() {
        return this.bundleInfo;
    }

    public DeploymentMetadata getDeploymentMetadata() {
        return this.deploymentMetadata;
    }

    public boolean isResolved() {
        return this.deploymentMetadata != null;
    }

    public void store(File arg0) throws FileNotFoundException, IOException {
        throw new UnsupportedOperationException();
    }

    public void store(OutputStream arg0) throws FileNotFoundException, IOException {
        throw new UnsupportedOperationException();
    }

    private void collectFileSystemBasedBundleInfos(File baseDir, ApplicationMetadataFactory applicationFactory) throws IOException {
        for (File file : baseDir.listFiles()) {
            if (file.isDirectory()) {
                this.collectFileSystemBasedBundleInfos(file, applicationFactory);
                continue;
            }
            BundleManifest bm = BundleManifest.fromBundle((File)file);
            if (bm == null || !bm.isValid()) continue;
            this.bundleInfo.add((BundleInfo)new SimpleBundleInfo(applicationFactory, bm, file.toURI().toString()));
        }
    }

    private void collectBundleEntryBasedBundleInfos(Bundle bundle, ApplicationMetadataFactory applicationFactory) throws IOException {
        Enumeration e = bundle.findEntries("/", "*", true);
        while (e.hasMoreElements()) {
            BundleManifest bm;
            URL url = (URL)e.nextElement();
            if (url.getPath().endsWith("/") || (bm = BundleManifest.fromBundle((InputStream)url.openStream())) == null || !bm.isValid()) continue;
            this.bundleInfo.add((BundleInfo)new SimpleBundleInfo(applicationFactory, bm, url.toExternalForm()));
        }
    }
}

