/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.aries.resolver.obr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.aries.application.ApplicationMetadata;
import org.apache.aries.application.Content;
import org.apache.aries.application.VersionRange;
import org.apache.aries.application.management.AriesApplication;
import org.apache.aries.application.management.AriesApplicationResolver;
import org.apache.aries.application.management.BundleInfo;
import org.apache.aries.application.management.ResolveConstraint;
import org.apache.aries.application.management.ResolverException;
import org.apache.aries.application.utils.manifest.ManifestHeaderProcessor;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.DataModelHelper;
import org.apache.felix.bundlerepository.Reason;
import org.apache.felix.bundlerepository.Repository;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.bundlerepository.Resolver;
import org.apache.felix.bundlerepository.Resource;
import org.apache.geronimo.aries.resolver.internal.MessageUtil;
import org.apache.geronimo.aries.resolver.obr.generator.RepositoryDescriptorGenerator;
import org.apache.geronimo.aries.resolver.obr.impl.ApplicationResourceImpl;
import org.apache.geronimo.aries.resolver.obr.impl.OBRBundleInfo;
import org.apache.geronimo.aries.resolver.obr.impl.ResourceWrapper;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class OBRAriesResolver
implements AriesApplicationResolver {
    private static Logger log = LoggerFactory.getLogger(OBRAriesResolver.class);
    private static final String LOG_ENTRY = "Method entry: {}, args {}";
    private static final String LOG_EXIT = "Method exit: {}, returning {}";
    private final RepositoryAdmin repositoryAdmin;
    private boolean returnOptionalResources = true;
    private boolean resolveFragments = false;
    private static final Set<String> SPECIAL_FILTER_ATTRS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("package", "symbolicname", "service", "version")));

    public OBRAriesResolver(RepositoryAdmin repositoryAdmin) {
        this.repositoryAdmin = repositoryAdmin;
    }

    public void setReturnOptionalResources(boolean optional) {
        this.returnOptionalResources = optional;
    }

    public boolean getReturnOptionalResources() {
        return this.returnOptionalResources;
    }

    public void setResolveFragments(boolean resolveFragments) {
        this.resolveFragments = resolveFragments;
    }

    public boolean getResolveFragments() {
        return this.resolveFragments;
    }

    public Set<BundleInfo> resolve(AriesApplication app, ResolveConstraint ... constraints) throws ResolverException {
        Repository[] repos;
        Repository appRepo;
        log.trace("resolving {}", (Object)app);
        DataModelHelper helper = this.repositoryAdmin.getHelper();
        ApplicationMetadata appMeta = app.getApplicationMetadata();
        String appName = appMeta.getApplicationSymbolicName();
        Version appVersion = appMeta.getApplicationVersion();
        List appContent = appMeta.getApplicationContents();
        try {
            Document doc = RepositoryDescriptorGenerator.generateRepositoryDescriptor(appName + "_" + appVersion, app.getBundleInfo());
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(doc), new StreamResult(bytesOut));
            appRepo = helper.readRepository((Reader)new InputStreamReader(new ByteArrayInputStream(bytesOut.toByteArray())));
        }
        catch (Exception e) {
            throw new ResolverException(e);
        }
        ArrayList<Repository> resolveRepos = new ArrayList<Repository>();
        resolveRepos.add(this.repositoryAdmin.getSystemRepository());
        resolveRepos.add(this.getLocalRepository(this.repositoryAdmin));
        resolveRepos.add(appRepo);
        for (Repository r : repos = this.repositoryAdmin.listRepositories()) {
            resolveRepos.add(r);
        }
        Resolver obrResolver = this.repositoryAdmin.resolver(resolveRepos.toArray(new Repository[resolveRepos.size()]));
        obrResolver.add(this.createApplicationResource(helper, appName, appVersion, appContent));
        log.debug("Resolving application resources");
        boolean resolved = obrResolver.resolve();
        log.debug("Resolution result: {}", (Object)resolved);
        if (resolved) {
            Set<BundleInfo> fragmentResult = null;
            if (this.resolveFragments) {
                fragmentResult = this.resolveFragments(obrResolver, resolveRepos, appName);
            }
            HashSet<BundleInfo> result = new HashSet<BundleInfo>();
            this.toBundleInfo(result, obrResolver.getRequiredResources(), false);
            if (this.returnOptionalResources) {
                this.toBundleInfo(result, obrResolver.getOptionalResources(), true);
            }
            if (fragmentResult != null) {
                result.addAll(fragmentResult);
            }
            return result;
        }
        throw this.createResolveException(appName, obrResolver);
    }

    private Set<BundleInfo> resolveFragments(Resolver obrResolver, List<Repository> resolveRepos, String appName) throws ResolverException {
        Resource fragmentResource;
        log.debug("Searching for fragments");
        HashSet<Resource> requiredFragments = new HashSet<Resource>();
        HashSet<Resource> optionalFragments = new HashSet<Resource>();
        for (Resource resource : obrResolver.getRequiredResources()) {
            fragmentResource = this.findFragmentResource(resource);
            if (fragmentResource == null) continue;
            requiredFragments.add(fragmentResource);
        }
        if (this.returnOptionalResources) {
            for (Resource resource : obrResolver.getOptionalResources()) {
                fragmentResource = this.findFragmentResource(resource);
                if (fragmentResource == null) continue;
                optionalFragments.add(fragmentResource);
            }
        }
        if (!requiredFragments.isEmpty() || !optionalFragments.isEmpty()) {
            Resolver fragmentResolver = this.repositoryAdmin.resolver(resolveRepos.toArray(new Repository[resolveRepos.size()]));
            for (Resource fragment : requiredFragments) {
                fragmentResolver.add(fragment);
            }
            for (Resource fragment : optionalFragments) {
                fragmentResolver.add(fragment);
            }
            log.debug("Resolving fragment resources, required={}, optional={}", requiredFragments, optionalFragments);
            boolean resolved = fragmentResolver.resolve();
            log.debug("Resolution result: {}", (Object)resolved);
            if (resolved) {
                HashSet<BundleInfo> result = new HashSet<BundleInfo>();
                this.toBundleInfo(result, requiredFragments, false);
                this.toBundleInfo(result, fragmentResolver.getRequiredResources(), false);
                if (this.returnOptionalResources) {
                    this.toBundleInfo(result, optionalFragments, true);
                    this.toBundleInfo(result, fragmentResolver.getOptionalResources(), true);
                }
                return result;
            }
            throw this.createResolveException(appName, fragmentResolver);
        }
        log.debug("No fragments found");
        return null;
    }

    private ResolverException createResolveException(String appName, Resolver obrResolver) {
        Reason[] reasons = obrResolver.getUnsatisfiedRequirements();
        Map<String, Set<String>> refinedReqs = this.refineUnsatisfiedRequirements(obrResolver, reasons);
        StringBuffer reqList = new StringBuffer();
        Map<String, String> unsatisfiedRequirements = this.extractConsumableMessageInfo(refinedReqs);
        for (String reason : unsatisfiedRequirements.keySet()) {
            reqList.append('\n');
            reqList.append(reason);
        }
        ResolverException re = new ResolverException(MessageUtil.getMessage("RESOLVER_UNABLE_TO_RESOLVE", appName, reqList));
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(unsatisfiedRequirements.keySet());
        re.setUnsatisfiedRequirements(list);
        return re;
    }

    private void toBundleInfo(Set<BundleInfo> result, Resource[] resources, boolean optional) {
        for (Resource resource : resources) {
            BundleInfo bundleInfo = this.toBundleInfo(resource, optional);
            result.add(bundleInfo);
        }
    }

    private void toBundleInfo(Set<BundleInfo> result, Collection<Resource> resources, boolean optional) {
        for (Resource resource : resources) {
            BundleInfo bundleInfo = this.toBundleInfo(resource, optional);
            result.add(bundleInfo);
        }
    }

    private Repository getLocalRepository(RepositoryAdmin admin) {
        Repository localRepository = this.repositoryAdmin.getLocalRepository();
        Resource[] resources = localRepository.getResources();
        Resource[] newResources = new Resource[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            newResources[i] = new ResourceWrapper(resources[i]);
        }
        return this.repositoryAdmin.getHelper().repository(newResources);
    }

    private Resource createApplicationResource(DataModelHelper helper, String appName, Version appVersion, List<Content> appContent) {
        return new ApplicationResourceImpl(appName, appVersion, appContent);
    }

    public BundleInfo getBundleInfo(String bundleSymbolicName, Version bundleVersion) {
        HashMap<String, String> attribs = new HashMap<String, String>();
        VersionRange range = ManifestHeaderProcessor.parseVersionRange((String)bundleVersion.toString(), (boolean)true);
        attribs.put("version", range.toString());
        String filterString = ManifestHeaderProcessor.generateFilter((String)"symbolicname", (String)bundleSymbolicName, attribs);
        try {
            Resource[] resources = this.repositoryAdmin.discoverResources(filterString);
            if (resources != null && resources.length > 0) {
                return this.toBundleInfo(resources[0], false);
            }
            return null;
        }
        catch (InvalidSyntaxException e) {
            log.error("Invalid filter", (Throwable)e);
            return null;
        }
    }

    private BundleInfo toBundleInfo(Resource resource, boolean optional) {
        HashMap<String, String> directives = null;
        if (optional) {
            directives = new HashMap<String, String>();
            directives.put("resolution", "optional");
        }
        String location = resource.getURI();
        return new OBRBundleInfo(resource.getSymbolicName(), resource.getVersion(), location, null, null, null, null, null, null, directives, null);
    }

    private Map<String, Set<String>> refineUnsatisfiedRequirements(Resolver resolver, Reason[] reasons) {
        log.debug(LOG_ENTRY, (Object)"refineUnsatisfiedRequirements", (Object)new Object[]{resolver, Arrays.toString(reasons)});
        HashMap<Requirement, HashSet<String>> req_resources = new HashMap<Requirement, HashSet<String>>();
        HashSet<Resource> resources = new HashSet<Resource>();
        for (Reason reason : reasons) {
            resources.add(reason.getResource());
            Requirement key = reason.getRequirement();
            String value = reason.getResource().getSymbolicName() + "_" + reason.getResource().getVersion().toString();
            HashSet<String> values = (HashSet<String>)req_resources.get(key);
            if (values == null) {
                values = new HashSet<String>();
            }
            values.add(value);
            req_resources.put(key, values);
        }
        HashSet<Capability> caps = new HashSet<Capability>();
        for (Resource res : resources) {
            List<Capability> capList;
            if (res == null || res.getCapabilities() == null || (capList = Arrays.asList(res.getCapabilities())) == null) continue;
            caps.addAll(capList);
        }
        Iterator iterator = req_resources.entrySet().iterator();
        block2: while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Requirement req = (Requirement)entry.getKey();
            for (Capability cap : caps) {
                if (!req.isSatisfied(cap)) continue;
                iterator.remove();
                continue block2;
            }
        }
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (Map.Entry req_res : req_resources.entrySet()) {
            result.put(((Requirement)req_res.getKey()).getFilter(), (Set<String>)req_res.getValue());
        }
        log.debug(LOG_EXIT, (Object)"refineUnsatisfiedRequirements", (Object)new Object[]{result});
        return result;
    }

    private Map<String, String> extractConsumableMessageInfo(Map<String, Set<String>> refinedReqs) {
        log.debug(LOG_ENTRY, (Object)"extractConsumableMessageInfo", refinedReqs);
        HashMap<String, String> unsatisfiedRequirements = new HashMap<String, String>();
        for (Map.Entry<String, Set<String>> filterEntry : refinedReqs.entrySet()) {
            String type;
            String filter = filterEntry.getKey();
            Set<String> bundlesFailing = filterEntry.getValue();
            log.debug("unable to satisfy the filter , filter = " + filter + "required by " + Arrays.toString(bundlesFailing.toArray()));
            Map attrs = ManifestHeaderProcessor.parseFilter((String)filter);
            HashMap customAttrs = new HashMap();
            for (Map.Entry e : attrs.entrySet()) {
                if (SPECIAL_FILTER_ATTRS.contains(e.getKey())) continue;
                customAttrs.put(e.getKey(), e.getValue());
            }
            StringBuilder msgKey = new StringBuilder();
            ArrayList<Object> inserts = new ArrayList<Object>();
            boolean unknownType = false;
            if (attrs.containsKey("package")) {
                type = "package";
                msgKey.append("RESOLVER_UNABLE_TO_RESOLVE_PACKAGE");
                inserts.add(attrs.get("package"));
            } else if (attrs.containsKey("symbolicname")) {
                type = "symbolicname";
                msgKey.append("RESOLVER_UNABLE_TO_RESOLVE_BUNDLE");
                inserts.add(attrs.get("symbolicname"));
            } else if (attrs.containsKey("service")) {
                type = "service";
                msgKey.append("RESOLVER_UNABLE_TO_RESOLVE_SERVICE");
            } else {
                type = "unknown";
                unknownType = true;
                msgKey.append("RESOLVER_UNABLE_TO_RESOLVE_FILTER");
                inserts.add(filter);
            }
            if (bundlesFailing != null && bundlesFailing.size() != 0) {
                msgKey.append("_REQUIRED_BY_BUNDLE");
                if (bundlesFailing.size() == 1) {
                    inserts.add(bundlesFailing.iterator().next());
                } else {
                    inserts.add(bundlesFailing.toString());
                }
            }
            if (!unknownType && !customAttrs.isEmpty()) {
                msgKey.append("_WITH_ATTRS");
                inserts.add(customAttrs);
            }
            if (!unknownType && attrs.containsKey("version")) {
                msgKey.append("_WITH_VERSION");
                VersionRange vr = ManifestHeaderProcessor.parseVersionRange((String)((String)attrs.get("version")));
                inserts.add(vr.getMinimumVersion());
                if (!vr.isExactVersion()) {
                    msgKey.append(vr.isMinimumExclusive() ? "_LOWEX" : "_LOW");
                    if (vr.getMaximumVersion() != null) {
                        msgKey.append(vr.isMaximumExclusive() ? "_UPEX" : "_UP");
                        inserts.add(vr.getMaximumVersion());
                    }
                }
            }
            String msgKeyStr = msgKey.toString();
            String msg = MessageUtil.getMessage(msgKeyStr, inserts.toArray());
            unsatisfiedRequirements.put(msg, type);
        }
        log.debug(LOG_EXIT, (Object)"extractConsumableMessageInfo", unsatisfiedRequirements);
        return unsatisfiedRequirements;
    }

    private Resource findFragmentResource(Resource hostResource) {
        Capability hostCapability = this.getHostCapability(hostResource.getCapabilities());
        if (hostCapability == null || "fragment".equals(hostCapability.getName())) {
            return null;
        }
        log.debug("Searching for fragments for {}", (Object)hostResource);
        DataModelHelper helper = this.repositoryAdmin.getHelper();
        String filter = "(&(host=" + hostResource.getSymbolicName() + "))";
        Requirement fragmentRequirement = helper.requirement("fragment", filter);
        Resource[] fragmentResources = this.repositoryAdmin.discoverResources(new Requirement[]{fragmentRequirement});
        if (fragmentResources != null && fragmentResources.length > 0) {
            if (log.isDebugEnabled()) {
                log.debug("Fragments found for {}: {}", new Object[]{hostResource, Arrays.asList(fragmentResources)});
            }
            ArrayList<Resource> candidateFragments = new ArrayList<Resource>();
            for (Resource fragmentResource : fragmentResources) {
                Requirement fragmentHostRequirement = this.getFragmentHostRequirement(fragmentResource.getRequirements());
                if (fragmentHostRequirement == null) {
                    log.debug("Ignoring {} fragment. No host requirement found.", (Object)fragmentResource);
                    continue;
                }
                if (!fragmentHostRequirement.isSatisfied(hostCapability)) continue;
                candidateFragments.add(fragmentResource);
            }
            int candiates = candidateFragments.size();
            if (candiates == 0) {
                log.debug("No matching fragments found for {}", (Object)hostResource);
                return null;
            }
            if (candiates == 1) {
                Resource fragmentResource = (Resource)candidateFragments.get(0);
                log.debug("Single matching fragment found for {}: {}", new Object[]{hostResource, fragmentResource});
                return fragmentResource;
            }
            Collections.sort(candidateFragments, new Comparator<Resource>(){

                @Override
                public int compare(Resource object1, Resource object2) {
                    Version version1 = object1.getVersion();
                    Version version2 = object2.getVersion();
                    return version2.compareTo(version1);
                }
            });
            Resource fragmentResource = (Resource)candidateFragments.get(0);
            log.debug("Multiple matching fragments found for {}. Fragment selected: {}", new Object[]{hostResource, fragmentResource});
            return fragmentResource;
        }
        log.debug("No fragments found for {}", (Object)hostResource);
        return null;
    }

    private Capability getHostCapability(Capability[] capabilities) {
        Capability bundleCapability = null;
        if (capabilities != null) {
            for (Capability capability : capabilities) {
                if ("bundle".equals(capability.getName()) && bundleCapability == null) {
                    bundleCapability = capability;
                    continue;
                }
                if (!"fragment".equals(capability.getName())) continue;
                return capability;
            }
        }
        return bundleCapability;
    }

    private Requirement getFragmentHostRequirement(Requirement[] requirements) {
        if (requirements != null) {
            for (Requirement requirement : requirements) {
                if (!"bundle".equals(requirement.getName()) || !requirement.isExtend()) continue;
                return requirement;
            }
        }
        return null;
    }
}

