/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.aries.jpa;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.aries.util.FragmentBuilder;
import org.apache.geronimo.hook.BundleHelper;
import org.apache.xbean.osgi.bundle.util.BundleDescription;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceBundleHelper {
    private static final Logger LOG = LoggerFactory.getLogger(PersistenceBundleHelper.class);
    private Map<Bundle, Bundle> fragmentMap = Collections.synchronizedMap(new HashMap());

    public void addProviderImports(BundleContext containerContext, Bundle persistenceBundle, ServiceReference providerReference) {
        Bundle providerBundle;
        BundleDescription providerDescription;
        if (persistenceBundle.getState() == 2 && providerReference != null && this.needsProviderImports(persistenceBundle, providerDescription = new BundleDescription((providerBundle = providerReference.getBundle()).getHeaders()))) {
            StringBuilder providerConstraint = new StringBuilder();
            providerConstraint.append(";");
            providerConstraint.append("bundle-symbolic-name");
            providerConstraint.append("=\"").append(providerBundle.getSymbolicName()).append("\"");
            providerConstraint.append(";");
            providerConstraint.append("bundle-version");
            String exportVersion = providerBundle.getVersion().toString();
            providerConstraint.append("=\"[").append(exportVersion).append(",").append(exportVersion).append("]\"");
            if (BundleHelper.isBundleExtenderSet()) {
                LOG.debug("Adding DynamicImport-Package for persistence bundle {}", (Object)persistenceBundle.getSymbolicName());
                StringBuilder packageList = new StringBuilder();
                Iterator iterator = providerDescription.getExportPackage().iterator();
                while (iterator.hasNext()) {
                    BundleDescription.ExportPackage exportPackage = (BundleDescription.ExportPackage)iterator.next();
                    packageList.append(exportPackage.getName()).append((CharSequence)providerConstraint);
                    if (!iterator.hasNext()) continue;
                    packageList.append(",");
                }
                BundleHelper.addDynamicImportPackage((long)persistenceBundle.getBundleId(), (String)packageList.toString());
            } else {
                Bundle fragment;
                LOG.debug("Generating JPA fragment for persistence bundle {}", (Object)persistenceBundle.getSymbolicName());
                FragmentBuilder builder = new FragmentBuilder(persistenceBundle, ".jpa.fragment", "JPA Fragment");
                for (BundleDescription.ExportPackage exportPackage : providerDescription.getExportPackage()) {
                    builder.addImports(new String[]{exportPackage.getName() + providerConstraint});
                }
                try {
                    fragment = builder.install(containerContext);
                }
                catch (IOException e) {
                    throw new RuntimeException("Error installing JPA fragment bundle", e);
                }
                catch (BundleException e) {
                    throw new RuntimeException("Error installing JPA fragment bundle", e);
                }
                this.fragmentMap.put(persistenceBundle, fragment);
            }
        }
    }

    private boolean needsProviderImports(Bundle persistenceBundle, BundleDescription providerDescription) {
        BundleDescription description = new BundleDescription(persistenceBundle.getHeaders());
        for (BundleDescription.HeaderEntry importPackage : description.getDynamicImportPackage()) {
            if (!"*".equals(importPackage.getName())) continue;
            LOG.debug("Persistence bundle {} can load any class.", (Object)persistenceBundle.getSymbolicName());
            return false;
        }
        for (BundleDescription.HeaderEntry importPackage : description.getImportPackage()) {
            for (BundleDescription.ExportPackage exportPackage : providerDescription.getExportPackage()) {
                if (!importPackage.getName().equals(exportPackage.getName()) || !importPackage.getVersionRange().isInRange(exportPackage.getVersion())) continue;
                LOG.debug("Persistence bundle {} already imports at least one package from JPA provider bundle.", (Object)persistenceBundle.getSymbolicName());
                return false;
            }
        }
        return true;
    }

    public void removeProviderImports(BundleContext containerContext, Bundle persistenceBundle) {
        if (persistenceBundle.getState() == 1) {
            if (BundleHelper.isBundleExtenderSet()) {
                LOG.debug("Persistence bundle {} was uninstalled. Removing DynamicImport-Package from persistence bundle", (Object)persistenceBundle.getSymbolicName());
                BundleHelper.removeDynamicImportPackage((long)persistenceBundle.getBundleId());
            } else {
                LOG.debug("Persistence bundle {} was uninstalled. Uninstalling the corresponding JPA fragment bundle", (Object)persistenceBundle.getSymbolicName());
                Bundle fragment = this.fragmentMap.remove(persistenceBundle);
                if (fragment != null) {
                    try {
                        fragment.uninstall();
                    }
                    catch (BundleException e) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

