/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.aries.builder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.aries.application.ApplicationMetadataFactory;
import org.apache.aries.application.DeploymentContent;
import org.apache.aries.application.DeploymentMetadata;
import org.apache.aries.application.DeploymentMetadataFactory;
import org.apache.aries.application.management.AriesApplication;
import org.apache.aries.application.management.AriesApplicationContext;
import org.apache.aries.application.management.AriesApplicationContextManager;
import org.apache.aries.application.management.AriesApplicationResolver;
import org.apache.aries.application.management.BundleInfo;
import org.apache.aries.application.management.ManagementException;
import org.apache.geronimo.aries.builder.ApplicationInstaller;
import org.apache.geronimo.aries.builder.GeronimoApplication;
import org.apache.geronimo.aries.builder.GeronimoApplicationContext;
import org.apache.geronimo.aries.builder.GeronimoApplicationContextManager;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean
public class ApplicationGBean
implements GBeanLifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationGBean.class);
    private final Bundle bundle;
    private final ApplicationInstaller installer;
    private final Artifact configId;
    private GeronimoApplication application;
    private AriesApplicationContext.ApplicationState applicationState;
    private Set<Bundle> applicationBundles;

    public ApplicationGBean(@ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel, @ParamSpecial(type=SpecialAttributeType.bundle) Bundle bundle, @ParamAttribute(name="configId") Artifact configId, @ParamReference(name="Installer") ApplicationInstaller installer) throws Exception {
        this.bundle = bundle;
        this.installer = installer;
        this.configId = configId;
        BundleContext bundleContext = bundle.getBundleContext();
        DeploymentMetadataFactory deploymentFactory = this.getDeploymentMetadataFactory(bundleContext);
        ApplicationMetadataFactory applicationFactory = this.getApplicationMetadataFactory(bundleContext);
        this.application = new GeronimoApplication(bundle, applicationFactory, deploymentFactory);
        this.install();
        GeronimoApplicationContextManager applicationManager = (GeronimoApplicationContextManager)this.getApplicationContextManager(bundleContext);
        applicationManager.registerApplicationContext(new GeronimoApplicationContext(this));
    }

    protected Bundle getBundle() {
        return this.bundle;
    }

    protected AriesApplication getAriesApplication() {
        return this.application;
    }

    protected Set<Bundle> getApplicationContent() {
        return new HashSet<Bundle>(this.applicationBundles);
    }

    protected AriesApplicationContext.ApplicationState getApplicationState() {
        return this.applicationState;
    }

    private AriesApplicationContextManager getApplicationContextManager(BundleContext bundleContext) {
        ServiceReference ref = bundleContext.getServiceReference(AriesApplicationContextManager.class.getName());
        if (ref != null) {
            return (AriesApplicationContextManager)bundleContext.getService(ref);
        }
        return null;
    }

    private DeploymentMetadataFactory getDeploymentMetadataFactory(BundleContext bundleContext) {
        ServiceReference ref = bundleContext.getServiceReference(DeploymentMetadataFactory.class.getName());
        if (ref != null) {
            return (DeploymentMetadataFactory)bundleContext.getService(ref);
        }
        return null;
    }

    private ApplicationMetadataFactory getApplicationMetadataFactory(BundleContext bundleContext) {
        ServiceReference ref = bundleContext.getServiceReference(ApplicationMetadataFactory.class.getName());
        if (ref != null) {
            return (ApplicationMetadataFactory)bundleContext.getService(ref);
        }
        return null;
    }

    private void install() throws Exception {
        BundleContext bundleContext = this.bundle.getBundleContext();
        AriesApplicationResolver resolver = null;
        ServiceReference ref = bundleContext.getServiceReference(AriesApplicationResolver.class.getName());
        if (ref != null) {
            resolver = (AriesApplicationResolver)bundleContext.getService(ref);
        }
        if (resolver == null) {
            throw new ManagementException("AriesApplicationResolver service not found");
        }
        DeploymentMetadata meta = this.application.getDeploymentMetadata();
        ArrayList bundlesToInstall = new ArrayList();
        bundlesToInstall.addAll(meta.getApplicationDeploymentContents());
        bundlesToInstall.addAll(meta.getApplicationProvisionBundles());
        this.applicationBundles = new HashSet<Bundle>();
        try {
            for (DeploymentContent content : bundlesToInstall) {
                String bundleSymbolicName = content.getContentName();
                Version bundleVersion = content.getExactVersion();
                BundleInfo bundleInfo = null;
                for (BundleInfo info : this.application.getBundleInfo()) {
                    if (!info.getSymbolicName().equals(bundleSymbolicName) || !info.getVersion().equals((Object)bundleVersion)) continue;
                    bundleInfo = info;
                    break;
                }
                if (bundleInfo == null) {
                    bundleInfo = resolver.getBundleInfo(bundleSymbolicName, bundleVersion);
                }
                if (bundleInfo == null) {
                    throw new ManagementException("Cound not find bundles: " + bundleSymbolicName + "_" + bundleVersion);
                }
                Bundle bundle = bundleContext.installBundle(bundleInfo.getLocation());
                this.applicationBundles.add(bundle);
            }
        }
        catch (BundleException be) {
            for (Bundle bundle : this.applicationBundles) {
                bundle.uninstall();
            }
            this.applicationBundles.clear();
            throw be;
        }
        finally {
            if (resolver != null) {
                bundleContext.ungetService(ref);
            }
        }
        this.applicationState = AriesApplicationContext.ApplicationState.INSTALLED;
    }

    public void doStart() throws Exception {
        LOG.debug("Starting {}", (Object)this.application.getApplicationMetadata().getApplicationScope());
        this.applicationState = AriesApplicationContext.ApplicationState.STARTING;
        ArrayList<Bundle> bundlesWeStarted = new ArrayList<Bundle>();
        try {
            for (Bundle b : this.applicationBundles) {
                if (!BundleUtils.canStart((Bundle)b)) continue;
                b.start(1);
                bundlesWeStarted.add(b);
            }
        }
        catch (BundleException be) {
            for (Bundle b : bundlesWeStarted) {
                try {
                    b.stop();
                }
                catch (BundleException be2) {}
            }
            this.applicationState = AriesApplicationContext.ApplicationState.INSTALLED;
            throw be;
        }
        this.applicationState = AriesApplicationContext.ApplicationState.ACTIVE;
    }

    public void doStop() {
        LOG.debug("Stopping {}", (Object)this.application.getApplicationMetadata().getApplicationScope());
        for (Bundle bundle : this.applicationBundles) {
            try {
                bundle.uninstall();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.applicationBundles.clear();
        this.applicationState = AriesApplicationContext.ApplicationState.RESOLVED;
    }

    public void doFail() {
        this.doStop();
    }

    protected void applicationStart() throws BundleException {
        try {
            this.installer.getConfigurationManager().loadConfiguration(this.configId);
            this.installer.getConfigurationManager().startConfiguration(this.configId);
        }
        catch (Exception e) {
            throw new BundleException("Failed to start application", (Throwable)e);
        }
    }

    protected void applicationStop() throws BundleException {
        try {
            this.installer.getConfigurationManager().unloadConfiguration(this.configId);
        }
        catch (Exception e) {
            throw new BundleException("Failed to start application", (Throwable)e);
        }
    }

    protected void applicationUninstall() {
        LOG.debug("Uninstalling {}", (Object)this.application.getApplicationMetadata().getApplicationScope());
        try {
            this.installer.getConfigurationManager().unloadConfiguration(this.configId);
            this.installer.getConfigurationManager().uninstallConfiguration(this.configId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.applicationState = AriesApplicationContext.ApplicationState.UNINSTALLED;
    }
}

