/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.activemq.management;

import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.apache.activemq.broker.TransportConnector;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.management.activemq.ActiveMQConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean(name="ActiveMQ Transport Connector")
public class ActiveMQTransportConnector
implements ActiveMQConnector {
    private static final Logger log = LoggerFactory.getLogger(ActiveMQTransportConnector.class);
    private final TransportConnector transportConnector;

    public ActiveMQTransportConnector(@ParamAttribute(manageable=false, name="transportConnector") TransportConnector transportConnector) {
        this.transportConnector = transportConnector;
    }

    public String getPath() {
        try {
            return this.transportConnector.getUri().toString();
        }
        catch (Exception e) {
            log.warn("error", (Throwable)e);
            return "Error: " + e.getMessage();
        }
    }

    public void setPath(String path) {
        throw new RuntimeException("Not implemented");
    }

    public String getQuery() {
        try {
            return this.transportConnector.getUri().getQuery();
        }
        catch (Exception e) {
            log.warn("error", (Throwable)e);
            return "Error: " + e.getMessage();
        }
    }

    public void setQuery(String query) {
        throw new RuntimeException("Not implemented");
    }

    public String getProtocol() {
        try {
            return this.transportConnector.getUri().getScheme();
        }
        catch (Exception e) {
            log.warn("error", (Throwable)e);
            return "Error: " + e.getMessage();
        }
    }

    public int getPort() {
        try {
            return this.transportConnector.getUri().getPort();
        }
        catch (Exception e) {
            log.warn("error", (Throwable)e);
            return -1;
        }
    }

    public void setPort(int port) {
        throw new RuntimeException("Not implemented");
    }

    public String getHost() {
        try {
            return this.transportConnector.getUri().getHost();
        }
        catch (Exception e) {
            log.warn("error", (Throwable)e);
            return "Error: " + e.getMessage();
        }
    }

    public void setHost(String host) throws UnknownHostException {
        throw new RuntimeException("Not implemented");
    }

    public InetSocketAddress getListenAddress() {
        return new InetSocketAddress(this.getHost(), this.getPort());
    }
}

