/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.service;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.ConfigurationBuilder;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.NamespaceDrivenBuilder;
import org.apache.geronimo.deployment.NamespaceDrivenBuilderCollection;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.deployment.xbeans.ArtifactType;
import org.apache.geronimo.deployment.xbeans.EnvironmentType;
import org.apache.geronimo.deployment.xbeans.ModuleDocument;
import org.apache.geronimo.deployment.xbeans.ModuleType;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.ConfigurationAlreadyExistsException;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.SimpleConfigurationManager;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactResolver;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.Repository;
import org.apache.geronimo.kernel.util.FileUtils;
import org.apache.geronimo.kernel.util.JarUtils;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.osgi.framework.BundleContext;

@GBean(j2eeType="ConfigBuilder")
public class ServiceConfigBuilder
implements ConfigurationBuilder,
GBeanLifecycle {
    private final Environment defaultEnvironment;
    private final Collection<Repository> repositories;
    private static final QName MODULE_QNAME = ModuleDocument.type.getDocumentElementName();
    public static final String SERVICE_MODULE = "ServiceModule";
    private static final Map<String, String> NAMESPACE_UPDATES = new HashMap<String, String>();
    private final Naming naming;
    private final ConfigurationManager configurationManager;
    private final NamespaceDrivenBuilderCollection serviceBuilders;
    private final BundleContext bundleContext;

    public ServiceConfigBuilder(Environment defaultEnvironment, Collection<Repository> repositories, Naming naming, BundleContext bundleContext) {
        this(defaultEnvironment, repositories, Collections.emptyList(), naming, null, bundleContext);
    }

    public ServiceConfigBuilder(@ParamAttribute(name="defaultEnvironment") Environment defaultEnvironment, @ParamReference(name="Repository", namingType="Repository") Collection<Repository> repositories, @ParamReference(name="ServiceBuilders", namingType="ModuleBuilder") Collection<NamespaceDrivenBuilder> serviceBuilders, @ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel, @ParamSpecial(type=SpecialAttributeType.bundleContext) BundleContext bundleContext) throws GBeanNotFoundException {
        this(defaultEnvironment, repositories, serviceBuilders, kernel.getNaming(), ConfigurationUtil.getConfigurationManager((Kernel)kernel), bundleContext);
    }

    public ServiceConfigBuilder(Environment defaultEnvironment, Collection<Repository> repositories, Collection<NamespaceDrivenBuilder> serviceBuilders, Naming naming, BundleContext bundleContext) {
        this(defaultEnvironment, repositories, serviceBuilders, naming, null, bundleContext);
    }

    public void doStart() throws Exception {
        XmlBeansUtil.registerNamespaceUpdates(NAMESPACE_UPDATES);
    }

    public void doStop() {
        XmlBeansUtil.unregisterNamespaceUpdates(NAMESPACE_UPDATES);
    }

    public void doFail() {
        this.doStop();
    }

    private ServiceConfigBuilder(Environment defaultEnvironment, Collection<Repository> repositories, Collection<NamespaceDrivenBuilder> serviceBuilders, Naming naming, ConfigurationManager configurationManager, BundleContext bundleContext) {
        this.naming = naming;
        this.configurationManager = configurationManager;
        this.defaultEnvironment = defaultEnvironment;
        this.repositories = repositories;
        this.serviceBuilders = new NamespaceDrivenBuilderCollection(serviceBuilders);
        this.bundleContext = bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getDeploymentPlan(File planFile, JarFile jarFile, ModuleIDBuilder idBuilder) throws DeploymentException {
        if (planFile == null && jarFile == null) {
            return null;
        }
        try {
            String name;
            int pos;
            XmlObject xmlObject;
            if (planFile != null) {
                xmlObject = XmlBeansUtil.parse((URL)planFile.toURI().toURL(), (ClassLoader)this.getClass().getClassLoader());
            } else {
                URL path = JarUtils.createJarURL((JarFile)jarFile, (String)"META-INF/geronimo-service.xml");
                try {
                    xmlObject = XmlBeansUtil.parse((URL)path, (ClassLoader)this.getClass().getClassLoader());
                }
                catch (FileNotFoundException e) {
                    return null;
                }
            }
            if (xmlObject == null) {
                return null;
            }
            XmlCursor cursor = xmlObject.newCursor();
            try {
                cursor.toFirstChild();
                if (!MODULE_QNAME.equals(cursor.getName())) {
                    Object e = null;
                    return e;
                }
            }
            finally {
                cursor.dispose();
            }
            ModuleDocument moduleDoc = xmlObject instanceof ModuleDocument ? (ModuleDocument)xmlObject : (ModuleDocument)xmlObject.changeType(ModuleDocument.type);
            XmlBeansUtil.validateDD((XmlObject)moduleDoc);
            if (jarFile != null) return moduleDoc.getModule();
            if (moduleDoc.getModule().getEnvironment() != null && moduleDoc.getModule().getEnvironment().getModuleId() != null) {
                if (moduleDoc.getModule().getEnvironment().getModuleId().getArtifactId() != null) return moduleDoc.getModule();
            }
            if (moduleDoc.getModule().getEnvironment() == null) {
                moduleDoc.getModule().addNewEnvironment();
            }
            if (moduleDoc.getModule().getEnvironment().getModuleId() == null) {
                moduleDoc.getModule().getEnvironment().addNewModuleId();
            }
            if ((pos = (name = planFile.getName()).lastIndexOf(46)) > -1) {
                name = name.substring(0, pos);
            }
            moduleDoc.getModule().getEnvironment().getModuleId().setArtifactId(name);
            return moduleDoc.getModule();
        }
        catch (XmlException e) {
            throw new DeploymentException("Could not parse xml in plan", (Throwable)e);
        }
        catch (IOException e) {
            throw new DeploymentException("no plan at " + planFile, (Throwable)e);
        }
    }

    public Artifact getConfigurationID(Object plan, JarFile module, ModuleIDBuilder idBuilder) throws IOException, DeploymentException {
        ModuleType configType = (ModuleType)plan;
        EnvironmentType environmentType = configType.getEnvironment();
        Environment environment = EnvironmentBuilder.buildEnvironment(environmentType, this.defaultEnvironment);
        idBuilder.resolve(environment, module == null ? "" : new File(module.getName()).getName(), "car");
        if (!environment.getConfigId().isResolved()) {
            throw new IllegalStateException("Service Module ID is not fully populated (" + environment.getConfigId() + ")");
        }
        return environment.getConfigId();
    }

    public DeploymentContext buildConfiguration(boolean inPlaceDeployment, Artifact configId, Object plan, JarFile jar, Collection<ConfigurationStore> configurationStores, ArtifactResolver artifactResolver, ConfigurationStore targetConfigurationStore) throws IOException, DeploymentException {
        ModuleType configType = (ModuleType)plan;
        return this.buildConfiguration(inPlaceDeployment, configId, configType, jar, configurationStores, artifactResolver, targetConfigurationStore);
    }

    private DeploymentContext buildConfiguration(boolean inPlaceDeployment, Artifact configId, ModuleType moduleType, JarFile jar, Collection<ConfigurationStore> configurationStores, ArtifactResolver artifactResolver, ConfigurationStore targetConfigurationStore) throws DeploymentException, IOException {
        ArtifactType type = moduleType.getEnvironment().isSetModuleId() ? moduleType.getEnvironment().getModuleId() : moduleType.getEnvironment().addNewModuleId();
        type.setArtifactId(configId.getArtifactId());
        type.setGroupId(configId.getGroupId());
        type.setType(configId.getType());
        type.setVersion(configId.getVersion().toString());
        Environment environment = EnvironmentBuilder.buildEnvironment(moduleType.getEnvironment(), this.defaultEnvironment);
        if (!environment.getConfigId().isResolved()) {
            throw new IllegalStateException("Module ID should be fully resolved by now (not " + environment.getConfigId() + ")");
        }
        try {
            targetConfigurationStore.createNewConfigurationDir(configId);
        }
        catch (ConfigurationAlreadyExistsException e) {
            throw new DeploymentException((Throwable)e);
        }
        DeploymentContext context = null;
        try {
            ConfigurationManager configurationManager = this.configurationManager;
            if (configurationManager == null) {
                configurationManager = new SimpleConfigurationManager(configurationStores, artifactResolver, this.repositories, this.bundleContext);
            }
            AbstractName moduleName = this.naming.createRootName(configId, configId.toString(), SERVICE_MODULE);
            File tempDirectory = FileUtils.createTempDir();
            context = new DeploymentContext(tempDirectory, inPlaceDeployment && null != jar ? JarUtils.toFile((JarFile)jar) : null, environment, moduleName, ConfigurationModuleType.SERVICE, this.naming, configurationManager, this.repositories, this.bundleContext);
            if (jar != null) {
                File file = new File(jar.getName());
                context.addIncludeAsPackedJar(URI.create(file.getName()), jar);
            }
            context.initializeConfiguration();
            this.serviceBuilders.build((XmlObject)moduleType, context, context);
            return context;
        }
        catch (DeploymentException de) {
            this.cleanupContext(context);
            throw de;
        }
        catch (IOException ie) {
            this.cleanupContext(context);
            throw ie;
        }
        catch (RuntimeException re) {
            this.cleanupContext(context);
            throw re;
        }
        catch (Error e) {
            this.cleanupContext(context);
            throw e;
        }
    }

    private void cleanupContext(DeploymentContext context) {
        if (context != null) {
            try {
                context.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/deployment", "http://geronimo.apache.org/xml/ns/deployment-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/deployment-1.1", "http://geronimo.apache.org/xml/ns/deployment-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/deployment/javabean", "http://geronimo.apache.org/xml/ns/deployment/javabean-1.0");
    }
}

