/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.util.FileUtils;
import org.apache.geronimo.system.plugin.ServerArchiver;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Tar;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.TarFileSet;
import org.apache.tools.ant.types.ZipFileSet;

public class ArchiverGBean
implements ServerArchiver {
    private final ServerInfo serverInfo;
    private List<String> excludes = new ArrayList<String>();
    public static final GBeanInfo GBEAN_INFO;

    public ArchiverGBean(ServerInfo serverInfo) {
        this.serverInfo = serverInfo;
    }

    public void addExclude(String pattern) {
        this.excludes.add(pattern);
    }

    public void removeExclude(String pattern) {
        this.excludes.remove(pattern);
    }

    private void removeExcludes(File source, Map<String, File> all) {
        HashMap matches = new HashMap();
        for (String exclude : this.excludes) {
            FileUtils.find((File)source, (String)exclude, matches);
        }
        for (String exclude : matches.keySet()) {
            all.remove(exclude);
        }
    }

    @Override
    public File archive(String sourcePath, String destPath, Artifact artifact) throws IOException {
        Zip archiver;
        File source = this.serverInfo.resolve(sourcePath);
        File dest = this.serverInfo.resolve(destPath);
        String serverName = artifact.getArtifactId() + "-" + artifact.getVersion();
        dest = new File(dest, serverName + "-bin." + artifact.getType());
        Project project = new Project();
        if ("tar.gz".equals(artifact.getType())) {
            Tar tar = new Tar();
            Tar.TarCompressionMethod tarCompressionMethod = new Tar.TarCompressionMethod();
            tarCompressionMethod.setValue("gzip");
            tar.setCompression(tarCompressionMethod);
            Tar.TarLongFileMode fileMode = new Tar.TarLongFileMode();
            fileMode.setValue("gnu");
            tar.setLongfile(fileMode);
            tar.setDestFile(dest);
            TarFileSet rc = new TarFileSet();
            rc.setDir(source);
            rc.setPrefix(serverName);
            rc.setProject(project);
            rc.setExcludes("bin/");
            tar.add((ResourceCollection)rc);
            rc = new TarFileSet();
            rc.setDir(source);
            rc.setPrefix(serverName);
            rc.setProject(project);
            rc.setIncludes("bin/");
            rc.setExcludes("bin/*.bat");
            rc.setFileMode("755");
            tar.add((ResourceCollection)rc);
            rc = new TarFileSet();
            rc.setDir(source);
            rc.setPrefix(serverName);
            rc.setProject(project);
            rc.setIncludes("bin/*.bat");
            tar.add((ResourceCollection)rc);
            archiver = tar;
        } else if ("zip".equals(artifact.getType())) {
            Zip zip = new Zip();
            zip.setDestFile(dest);
            ZipFileSet fs = new ZipFileSet();
            fs.setDir(source);
            fs.setPrefix(serverName);
            fs.setProject(project);
            zip.addFileset((FileSet)fs);
            archiver = zip;
        } else {
            throw new IllegalArgumentException("Unknown target type: " + artifact.getType());
        }
        archiver.setProject(project);
        archiver.execute();
        return dest;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(ArchiverGBean.class);
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.setConstructor(new String[]{"ServerInfo"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

