/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.plugin;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.basic.BasicKernel;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.PersistentConfigurationList;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.system.plugin.DownloadPoller;
import org.apache.geronimo.system.plugin.DownloadResults;
import org.apache.geronimo.system.plugin.GeronimoSourceRepository;
import org.apache.geronimo.system.plugin.NewServerInstance;
import org.apache.geronimo.system.plugin.PluginInstallerGBean;
import org.apache.geronimo.system.plugin.model.ArtifactType;
import org.apache.geronimo.system.plugin.model.PluginArtifactType;
import org.apache.geronimo.system.plugin.model.PluginListType;
import org.apache.geronimo.system.plugin.model.PluginType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GBean
public class NewServerInstanceGBean
implements NewServerInstance {
    private final Set<String> defaultPlugins;
    private final Collection<PersistentConfigurationList> persistentConfigurationLists;
    private final PluginInstallerGBean oldPluginInstallerGBean;
    private final ConfigurationManager configManager;
    private final Kernel kernel;

    public NewServerInstanceGBean(@ParamAttribute(name="defaultPlugins") Map<String, String> defaultPlugins, @ParamReference(name="PersistentConfigurationList", namingType="PersistentConfigurationList.PERSISTENT_CONFIGURATION_LIST") Collection<PersistentConfigurationList> persistentConfigurationLists, @ParamReference(name="PluginInstallerGBean") PluginInstallerGBean pluginInstallerGBean, @ParamReference(name="ConfigManager", namingType="ConfigurationManager") ConfigurationManager configManager, @ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel) {
        this.persistentConfigurationLists = persistentConfigurationLists;
        this.oldPluginInstallerGBean = pluginInstallerGBean;
        this.configManager = configManager;
        this.defaultPlugins = defaultPlugins == null ? Collections.emptySet() : defaultPlugins.keySet();
        this.kernel = kernel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newServerInstance(String serverName) throws Exception {
        try {
            PluginListType pluginList = new PluginListType();
            for (String artifactString : this.defaultPlugins) {
                Artifact artifact = Artifact.create((String)artifactString);
                PluginType plugin = this.getPlugin(artifact);
                pluginList.getPlugin().add(plugin);
            }
            Artifact query = Artifact.createPartial((String)"///");
            for (PersistentConfigurationList persistentConfigurationList : this.persistentConfigurationLists) {
                for (Artifact installed : persistentConfigurationList.getListedConfigurations(query)) {
                    PluginType plugin = this.getPlugin(installed);
                    pluginList.getPlugin().add(plugin);
                }
            }
            BasicKernel kernel = new BasicKernel("assembly");
            try {
                PluginInstallerGBean pluginInstallerGBean = this.oldPluginInstallerGBean.pluginInstallerCopy(serverName, (Kernel)kernel);
                GeronimoSourceRepository localSourceRepository = new GeronimoSourceRepository(this.configManager.getRepositories(), this.configManager.getArtifactResolver());
                DownloadResults downloadPoller = new DownloadResults();
                pluginInstallerGBean.install(pluginList, localSourceRepository, true, null, null, (DownloadPoller)downloadPoller);
            }
            finally {
                kernel.shutdown();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public PluginType getPlugin(Artifact sourceArtifact) {
        PluginType plugin = new PluginType();
        PluginArtifactType pluginArtifact = new PluginArtifactType();
        ArtifactType artifact = new ArtifactType();
        artifact.setGroupId(sourceArtifact.getGroupId());
        artifact.setArtifactId(sourceArtifact.getArtifactId());
        artifact.setVersion(sourceArtifact.getVersion().toString());
        artifact.setType(sourceArtifact.getType());
        pluginArtifact.setModuleId(artifact);
        plugin.getPluginArtifact().add(pluginArtifact);
        return plugin;
    }
}

