/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.system.plugin.PluginRepositoryList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginRepositoryDownloader
implements PluginRepositoryList {
    private static final Log log = LogFactory.getLog(PluginRepositoryDownloader.class);
    private List<String> downloadRepositories = new ArrayList<String>();
    private List<String> userRepositories = new ArrayList<String>();
    private Kernel kernel;
    private AbstractName name;
    private URL repositoryList;
    public static final GBeanInfo GBEAN_INFO;

    public PluginRepositoryDownloader(List<String> downloadRepositories, List<String> userRepositories, URL repositoryList, Kernel kernel, AbstractName name) {
        if (downloadRepositories != null) {
            this.downloadRepositories = downloadRepositories;
        }
        if (userRepositories != null) {
            this.userRepositories = userRepositories;
        }
        this.repositoryList = repositoryList;
        this.kernel = kernel;
        this.name = name;
    }

    public void setDownloadRepositories(List<String> downloadRepositories) {
        this.downloadRepositories = downloadRepositories;
        if (this.downloadRepositories == null) {
            this.downloadRepositories = new ArrayList<String>();
        }
    }

    public void setUserRepositories(List<String> userRepositories) {
        this.userRepositories = userRepositories;
        if (this.userRepositories == null) {
            this.userRepositories = new ArrayList<String>();
        }
    }

    @Override
    public List<URL> getRepositories() {
        ArrayList<URL> list = new ArrayList<URL>();
        for (String url : this.downloadRepositories) {
            if (!(url = url.trim()).endsWith("/")) {
                url = url + "/";
            }
            try {
                list.add(new URL(url));
            }
            catch (MalformedURLException e) {
                log.error((Object)("Unable to format plugin repository URL " + url), (Throwable)e);
            }
        }
        for (String userRepository : this.userRepositories) {
            userRepository = userRepository.trim();
            URL url = null;
            try {
                url = PluginRepositoryDownloader.resolveRepository(userRepository).toURL();
            }
            catch (MalformedURLException e) {
                log.error((Object)("Unable to format plugin repository URL " + userRepository), (Throwable)e);
            }
            if (url == null) continue;
            list.add(url);
        }
        return list;
    }

    static URI resolveRepository(String userRepository) {
        if (!userRepository.endsWith("/")) {
            userRepository = userRepository + "/";
        }
        try {
            userRepository = userRepository.replaceAll(" ", "%20");
            URI uri = new URI(userRepository);
            if (!uri.isAbsolute()) {
                if (userRepository.startsWith("/")) {
                    return new URI("file", userRepository, null);
                }
                if (userRepository.startsWith("~")) {
                    return new File(System.getProperty("user.home")).getAbsoluteFile().toURI().resolve(userRepository.substring(2));
                }
            } else {
                return uri;
            }
            log.error((Object)("Can't interpret path: " + userRepository));
        }
        catch (URISyntaxException e) {
            log.error((Object)("Unable to format plugin repository URL " + userRepository), (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader(this.repositoryList.openStream()));
            ArrayList<String> list = new ArrayList<String>();
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).equals("") || line.startsWith("#")) continue;
                list.add(line);
            }
            in.close();
            in = null;
            this.kernel.setAttribute(this.name, "downloadRepositories", list);
        }
        catch (Exception e) {
            log.error((Object)"Unable to save download repositories", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void addUserRepository(URL repo) {
        this.userRepositories.add(repo.toString());
        try {
            this.kernel.setAttribute(this.name, "userRepositories", this.userRepositories);
        }
        catch (Exception e) {
            log.error((Object)"Unable to save user repositories", (Throwable)e);
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(PluginRepositoryDownloader.class);
        infoFactory.addAttribute("downloadRepositories", List.class, true);
        infoFactory.addAttribute("userRepositories", List.class, true);
        infoFactory.addAttribute("repositoryList", URL.class, true);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addAttribute("abstractName", AbstractName.class, false);
        infoFactory.addInterface(PluginRepositoryList.class);
        infoFactory.setConstructor(new String[]{"downloadRepositories", "userRepositories", "repositoryList", "kernel", "abstractName"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

