/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.plugin;

import java.io.File;
import java.net.URI;
import org.apache.geronimo.system.plugin.LocalSourceRepository;
import org.apache.geronimo.system.plugin.PluginRepositoryDownloader;
import org.apache.geronimo.system.plugin.RemoteSourceRepository;
import org.apache.geronimo.system.plugin.SourceRepository;

public class SourceRepositoryFactory {
    private SourceRepositoryFactory() {
    }

    public static SourceRepository getSourceRepository(String repo) {
        return SourceRepositoryFactory.getSourceRepository(repo, null, null);
    }

    public static SourceRepository getSourceRepository(String repo, String user, String pass) {
        if (repo == null) {
            throw new IllegalArgumentException("No repo supplied");
        }
        URI repoURI = PluginRepositoryDownloader.resolveRepository(repo);
        if (repoURI == null) {
            throw new IllegalStateException("Can't locate repo " + repo);
        }
        String scheme = repoURI.getScheme();
        if (scheme.startsWith("http")) {
            return new RemoteSourceRepository(repoURI, user, pass);
        }
        if ("file".equals(scheme)) {
            return new LocalSourceRepository(new File(repoURI));
        }
        throw new IllegalStateException("Cannot identify desired repo type for " + repo);
    }
}

