/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming.java;

import java.net.URI;
import java.util.Collections;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.xbean.naming.context.ImmutableContext;

public class RootContext
extends ImmutableContext {
    private static InheritableThreadLocal<Context> compContext = new InheritableThreadLocal();
    private static InheritableThreadLocal<URI> openejbRemoteContextURI = new InheritableThreadLocal();

    public RootContext() throws NamingException {
        super(Collections.emptyMap());
    }

    public Object lookup(String name) throws NamingException {
        if (name.startsWith("java:")) {
            Context compCtx = (Context)compContext.get();
            if (compCtx == null) {
                throw new NameNotFoundException("No thread context set, looking up: " + name);
            }
            if (name.length() == 5) {
                return compCtx;
            }
            name = name.charAt(5) == '/' ? name.substring(6) : name.substring(5);
            try {
                return compCtx.lookup(name);
            }
            catch (NamingException e1) {
                if (openejbRemoteContextURI.get() != null && name.startsWith("global/")) {
                    Properties p = new Properties();
                    p.put("java.naming.factory.initial", "org.apache.openejb.client.RemoteInitialContextFactory");
                    p.put("java.naming.provider.url", ((URI)openejbRemoteContextURI.get()).toString());
                    p.put("openejb.client.moduleId", "openejb/global");
                    try {
                        InitialContext ctx = new InitialContext(p);
                        Object value = ctx.lookup(name);
                        return value;
                    }
                    catch (NamingException e2) {
                        throw (NameNotFoundException)new NameNotFoundException().initCause(e2);
                    }
                }
                throw e1;
            }
        }
        return super.lookup(name);
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public static void setComponentContext(Context ctx) {
        compContext.set(ctx);
    }

    public static void setOpenejbRemoteContextURI(URI uri) {
        openejbRemoteContextURI.set(uri);
    }

    public static Context getComponentContext() {
        return (Context)compContext.get();
    }
}

