/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming.reference;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.naming.reference.SimpleAwareReference;

public abstract class ConfigurationAwareReference
extends SimpleAwareReference {
    private static final long serialVersionUID = 283358809226901462L;
    private final Artifact[] configId;
    protected final Set<AbstractNameQuery> abstractNameQueries;

    protected ConfigurationAwareReference(Artifact[] configId, AbstractNameQuery abstractNameQuery) {
        this(configId, Collections.singleton(abstractNameQuery));
    }

    protected ConfigurationAwareReference(Artifact[] configId, Set<AbstractNameQuery> abstractNameQueries) {
        if (configId == null || configId.length == 0) {
            throw new NullPointerException("No configId");
        }
        this.configId = configId;
        this.abstractNameQueries = abstractNameQueries;
    }

    public Configuration getConfiguration() throws GBeanNotFoundException {
        Configuration configuration;
        block3: {
            Kernel kernel = this.getKernel();
            ConfigurationManager configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)kernel);
            configuration = configurationManager.getConfiguration(this.configId[0]);
            if (configuration == null) {
                throw new IllegalStateException("No configuration found for id: " + this.configId[0]);
            }
            int i = 1;
            if (i < this.configId.length) {
                List children = configuration.getChildren();
                for (Configuration child : children) {
                    if (!child.getId().equals((Object)this.configId[i])) continue;
                    configuration = child;
                    break block3;
                }
                throw new GBeanNotFoundException("No configuration found for id: " + this.configId[i], null);
            }
        }
        return configuration;
    }

    public AbstractName resolveTargetName() throws GBeanNotFoundException {
        Configuration configuration = this.getConfiguration();
        try {
            return configuration.findGBean(this.abstractNameQueries);
        }
        catch (GBeanNotFoundException e) {
            Set results = this.getKernel().listGBeans(this.abstractNameQueries);
            if (results.size() == 1) {
                return (AbstractName)results.iterator().next();
            }
            throw new GBeanNotFoundException("Name query " + this.abstractNameQueries + " not satisfied in kernel, matches: " + results, (Throwable)e);
        }
    }
}

