/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming.reference;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.naming.reference.EntryFactory;

public abstract class AbstractEntryFactory<T, S>
implements EntryFactory<T> {
    private static final long serialVersionUID = 7642216668523441421L;
    private final Artifact[] configId;
    private final Set<AbstractNameQuery> abstractNameQueries;
    private final Class<S> gbeanClass;

    protected AbstractEntryFactory(Artifact[] configId, AbstractNameQuery abstractNameQuery, Class<S> gbeanClass) {
        this(configId, Collections.singleton(abstractNameQuery), gbeanClass);
    }

    protected AbstractEntryFactory(Artifact[] configId, Set<AbstractNameQuery> abstractNameQueries, Class<S> gbeanClass) {
        if (configId == null || configId.length == 0) {
            throw new NullPointerException("No configId");
        }
        this.configId = configId;
        this.abstractNameQueries = abstractNameQueries;
        this.gbeanClass = gbeanClass;
    }

    protected S getGBean(Kernel kernel) throws NamingException {
        Object proxy;
        AbstractName target;
        try {
            target = this.resolveTargetName(kernel);
        }
        catch (GBeanNotFoundException e) {
            throw (NameNotFoundException)new NameNotFoundException("Could not resolve name query: " + this.abstractNameQueries).initCause(e);
        }
        try {
            proxy = kernel.getGBean(target);
        }
        catch (Exception e) {
            throw (IllegalStateException)new IllegalStateException("Could not get proxy").initCause(e);
        }
        if (proxy == null) {
            throw new IllegalStateException("Proxy not returned. Target " + target + " not started");
        }
        this.checkClass(proxy, this.gbeanClass);
        return (S)proxy;
    }

    protected void checkClass(Object proxy, Class clazz) {
        if (!clazz.isAssignableFrom(proxy.getClass())) {
            Class<?> proxyClass = proxy.getClass();
            Class<?>[] interfaces = proxyClass.getInterfaces();
            StringBuffer message = new StringBuffer();
            boolean namesMatch = false;
            for (Class<?> anInterface : interfaces) {
                if (!clazz.getName().equals(anInterface.getName())) continue;
                namesMatch = true;
                message.append("Proxy implements correct interface: ").append(clazz.getName()).append(", but classloaders differ\n");
                message.append("lookup interface classloader: ").append(clazz.getClassLoader().toString()).append("\n");
                message.append("target interface classloader: ").append(anInterface.getClassLoader().toString()).append("\n");
                message.append("target proxy classloader: ").append(proxy.getClass().getClassLoader());
                break;
            }
            if (!namesMatch) {
                message.append("Proxy does not implement an interface named: ").append(clazz.getName());
            }
            throw new ClassCastException(message.toString());
        }
    }

    public Configuration getConfiguration(Kernel kernel) throws GBeanNotFoundException {
        Configuration configuration;
        block3: {
            ConfigurationManager configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)kernel);
            configuration = configurationManager.getConfiguration(this.configId[0]);
            if (configuration == null) {
                throw new IllegalStateException("No configuration found for id: " + this.configId[0]);
            }
            int i = 1;
            if (i < this.configId.length) {
                List children = configuration.getChildren();
                for (Configuration child : children) {
                    if (!child.getId().equals((Object)this.configId[i])) continue;
                    configuration = child;
                    break block3;
                }
                throw new GBeanNotFoundException("No configuration found for id: " + this.configId[i], null);
            }
        }
        return configuration;
    }

    public AbstractName resolveTargetName(Kernel kernel) throws GBeanNotFoundException {
        Configuration configuration = this.getConfiguration(kernel);
        try {
            return configuration.findGBean(this.abstractNameQueries);
        }
        catch (GBeanNotFoundException e) {
            Set results = kernel.listGBeans(this.abstractNameQueries);
            if (results.size() == 1) {
                return (AbstractName)results.iterator().next();
            }
            throw new GBeanNotFoundException("Name query " + this.abstractNameQueries + " not satisfied in kernel, matches: " + results, (Throwable)e);
        }
    }
}

