/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming.java;

import java.util.Collections;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.xbean.naming.context.ImmutableContext;

public class RootContext
extends ImmutableContext {
    private static InheritableThreadLocal<Context> compContext = new InheritableThreadLocal();

    public RootContext() throws NamingException {
        super(Collections.emptyMap());
    }

    public Object lookup(String name) throws NamingException {
        if (name.startsWith("java:")) {
            Context compCtx = (Context)compContext.get();
            if (compCtx == null) {
                throw new NameNotFoundException("No thread context set, looking up: " + name);
            }
            if (name.length() == 5) {
                return compCtx;
            }
            name = name.charAt(5) == '/' ? name.substring(6) : name.substring(5);
            return compCtx.lookup(name);
        }
        return super.lookup(name);
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public static void setComponentContext(Context ctx) {
        compContext.set(ctx);
    }

    public static Context getComponentContext() {
        return (Context)compContext.get();
    }
}

