/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.management.stats;

import javax.management.j2ee.statistics.RangeStatistic;
import org.apache.geronimo.management.stats.StatisticImpl;

public class RangeStatisticImpl
extends StatisticImpl
implements RangeStatistic {
    private long highWaterMark;
    private long lowWaterMark;
    private long current;

    public RangeStatisticImpl(String name, String unit, String description) {
        super(name, unit, description);
    }

    public RangeStatisticImpl(String name, String unit, String description, long currentValue) {
        super(name, unit, description);
        this.lowWaterMark = this.current = currentValue;
        this.highWaterMark = this.current;
    }

    public long getHighWaterMark() {
        return this.highWaterMark;
    }

    public long getLowWaterMark() {
        return this.lowWaterMark;
    }

    public long getCurrent() {
        return this.current;
    }

    public void setCurrent(long current) {
        this.current = current;
        if (current < this.lowWaterMark) {
            this.lowWaterMark = current;
        }
        if (current > this.highWaterMark) {
            this.highWaterMark = current;
        }
    }

    public void setHighWaterMark(long highWaterMark) {
        this.highWaterMark = highWaterMark;
    }

    public void setLowWaterMark(long lowWaterMark) {
        this.lowWaterMark = lowWaterMark;
    }

    public String toString() {
        return this.getName() + " in " + this.getUnit() + " -- current: " + this.current + ", highWaterMark: " + this.highWaterMark + ", lowWaterMark: " + this.lowWaterMark;
    }
}

