/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.management.geronimo;

import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.List;
import org.apache.geronimo.common.propertyeditor.PropertyEditors;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.management.geronimo.NetworkManager;
import org.apache.geronimo.management.geronimo.WebAccessLog;
import org.apache.geronimo.management.geronimo.WebContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface WebManager
extends NetworkManager {
    public static final String PROTOCOL_HTTP = "HTTP";
    public static final String PROTOCOL_HTTPS = "HTTPS";
    public static final String PROTOCOL_AJP = "AJP";

    public WebAccessLog getAccessLog(WebContainer var1);

    public List<ConnectorType> getConnectorTypes();

    public List<ConnectorAttribute> getConnectorAttributes(ConnectorType var1);

    public AbstractName getConnectorConfiguration(ConnectorType var1, List<ConnectorAttribute> var2, WebContainer var3, String var4);

    public ConnectorType getConnectorType(AbstractName var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConnectorAttribute<T> {
        private final String attributeName;
        private String stringValue;
        private final Class<T> clazz;
        private T value;
        private final String description;
        private boolean required;

        public ConnectorAttribute(String attributeName, T value, String description, Class<T> clazz, boolean required) {
            this.attributeName = attributeName;
            this.value = value;
            this.description = description;
            this.clazz = clazz;
            this.required = required;
        }

        public ConnectorAttribute(String attributeName, T value, String description, Class<T> clazz) {
            this(attributeName, value, description, clazz, false);
        }

        public ConnectorAttribute(ConnectorAttribute<T> connectorAttribute) {
            this.attributeName = connectorAttribute.attributeName;
            this.value = connectorAttribute.value;
            this.description = connectorAttribute.description;
            this.clazz = connectorAttribute.clazz;
            this.required = connectorAttribute.required;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public String getStringValue() {
            if (this.value == null) {
                return null;
            }
            PropertyEditor propertyEditor = PropertyEditors.getEditor(this.clazz);
            propertyEditor.setValue(this.value);
            return propertyEditor.getAsText();
        }

        public void setStringValue(String stringValue) {
            PropertyEditor propertyEditor = PropertyEditors.getEditor(this.clazz);
            propertyEditor.setAsText(stringValue);
            this.value = propertyEditor.getValue();
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }

        public String getDescription() {
            return this.description;
        }

        public static List<ConnectorAttribute> copy(List<ConnectorAttribute> source) {
            ArrayList<ConnectorAttribute> copy = new ArrayList<ConnectorAttribute>(source.size());
            for (ConnectorAttribute connectorAttribute : source) {
                copy.add(new ConnectorAttribute(connectorAttribute));
            }
            return copy;
        }

        public Class<T> getAttributeClass() {
            return this.clazz;
        }

        public boolean isRequired() {
            return this.required;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }
    }

    public static class ConnectorType {
        private final String description;

        public ConnectorType(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConnectorType other = (ConnectorType)obj;
            return !(this.description == null ? other.description != null : !this.description.equals(other.description));
        }
    }
}

