/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.util;

import java.io.IOException;
import java.io.InputStream;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelFactory;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.util.Main;

public class MainConfigurationBootstrapper {
    protected Kernel kernel;

    public static void main(String[] args) {
        int status = MainConfigurationBootstrapper.main(new MainConfigurationBootstrapper(), args);
        System.exit(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int main(MainConfigurationBootstrapper bootstrapper, Object opaque) {
        int exitCode;
        Main main = bootstrapper.getMain(MainConfigurationBootstrapper.class.getClassLoader());
        ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader newTCCL = main.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(newTCCL);
            exitCode = main.execute(opaque);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTCCL);
        }
        return exitCode;
    }

    public Main getMain(ClassLoader classLoader) {
        try {
            this.bootKernel();
            this.loadBootConfiguration(classLoader);
            this.loadPersistentConfigurations();
            return this.getMain();
        }
        catch (Exception e) {
            if (null != this.kernel) {
                this.kernel.shutdown();
            }
            e.printStackTrace();
            System.exit(1);
            throw new AssertionError();
        }
    }

    public void bootKernel() throws Exception {
        this.kernel = KernelFactory.newInstance().createKernel("MainBootstrapper");
        this.kernel.boot();
        Runtime.getRuntime().addShutdownHook(new Thread("MainBootstrapper shutdown thread"){

            public void run() {
                MainConfigurationBootstrapper.this.kernel.shutdown();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadBootConfiguration(ClassLoader classLoader) throws Exception {
        InputStream in = classLoader.getResourceAsStream("META-INF/config.ser");
        try {
            ConfigurationUtil.loadBootstrapConfiguration(this.kernel, in, classLoader, true);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void loadPersistentConfigurations() throws Exception {
    }

    public Main getMain() throws Exception {
        return this.kernel.getGBean(Main.class);
    }

    public Kernel getKernel() {
        return this.kernel;
    }
}

