/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.geronimo.kernel.repository.Artifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationStatus {
    private Artifact configurationId;
    private final Set<ConfigurationStatus> loadParents = new LinkedHashSet<ConfigurationStatus>();
    private final Set<ConfigurationStatus> startParents = new LinkedHashSet<ConfigurationStatus>();
    private final LinkedHashSet<ConfigurationStatus> loadChildren = new LinkedHashSet();
    private final LinkedHashSet<ConfigurationStatus> startChildren = new LinkedHashSet();
    private boolean loaded = false;
    private boolean started = false;
    private boolean userLoaded = false;
    private boolean userStarted = false;

    public ConfigurationStatus(Artifact configId, Set<ConfigurationStatus> loadParents, Set<ConfigurationStatus> startParents) {
        if (configId == null) {
            throw new NullPointerException("configId is null");
        }
        if (loadParents == null) {
            throw new NullPointerException("loadParents is null");
        }
        if (startParents == null) {
            throw new NullPointerException("startParents is null");
        }
        if (!loadParents.containsAll(startParents)) {
            throw new IllegalArgumentException("loadParents must contain all startParents");
        }
        this.configurationId = configId;
        this.loadParents.addAll(loadParents);
        this.startParents.addAll(startParents);
        for (ConfigurationStatus loadParent : loadParents) {
            loadParent.loadChildren.add(this);
        }
        for (ConfigurationStatus startParent : startParents) {
            startParent.startChildren.add(this);
        }
    }

    public void destroy() {
        if (this.started) {
            throw new IllegalStateException("Configuration " + this.configurationId + " is still running");
        }
        if (this.loaded) {
            throw new IllegalStateException("Configuration " + this.configurationId + " is still loaded");
        }
        if (this.loadChildren.size() > 0 || this.startChildren.size() > 0) {
            throw new IllegalStateException("Configuration " + this.configurationId + " still has children");
        }
        for (ConfigurationStatus loadParent : this.loadParents) {
            loadParent.loadChildren.remove(this);
        }
        this.loadParents.clear();
        for (ConfigurationStatus startParent : this.startParents) {
            startParent.startChildren.remove(this);
        }
        this.startChildren.clear();
    }

    public Artifact getConfigurationId() {
        return this.configurationId;
    }

    public LinkedHashSet<Artifact> getStartedChildren() {
        LinkedHashSet<ConfigurationStatus> childrenStatuses = new LinkedHashSet<ConfigurationStatus>();
        this.getStartedChildrenInternal(childrenStatuses);
        LinkedHashSet<Artifact> childrenIds = new LinkedHashSet<Artifact>(childrenStatuses.size());
        for (ConfigurationStatus configurationStatus : childrenStatuses) {
            childrenIds.add(configurationStatus.configurationId);
        }
        return childrenIds;
    }

    private void getStartedChildrenInternal(LinkedHashSet<ConfigurationStatus> childrenStatuses) {
        if (!this.started) {
            return;
        }
        for (ConfigurationStatus child : this.startChildren) {
            if (!child.isStarted() || child.configurationId.equals(this.configurationId)) continue;
            child.getStartedChildrenInternal(childrenStatuses);
        }
        childrenStatuses.add(this);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isUserLoaded() {
        return this.userLoaded;
    }

    public boolean isUserStarted() {
        return this.userStarted;
    }

    public void upgrade(Artifact newId, Set<ConfigurationStatus> newLoadParents, Set<ConfigurationStatus> newStartParents) {
        this.configurationId = newId;
        for (ConfigurationStatus loadParent : this.loadParents) {
            loadParent.loadChildren.remove(this);
        }
        this.loadParents.clear();
        for (ConfigurationStatus startParent : this.startParents) {
            startParent.startChildren.remove(this);
        }
        this.startChildren.clear();
        this.loadParents.addAll(newLoadParents);
        this.startParents.addAll(newStartParents);
        for (ConfigurationStatus loadParent : this.loadParents) {
            loadParent.loadChildren.add(this);
        }
        for (ConfigurationStatus startParent : this.startParents) {
            startParent.startChildren.add(this);
        }
    }

    public LinkedHashSet<Artifact> load() {
        LinkedHashSet<Artifact> loadList = new LinkedHashSet<Artifact>();
        this.loadInternal(loadList);
        this.userLoaded = true;
        return loadList;
    }

    private void loadInternal(LinkedHashSet<Artifact> loadList) {
        for (ConfigurationStatus parent : this.loadParents) {
            if (parent.isLoaded()) continue;
            parent.loadInternal(loadList);
        }
        if (!this.loaded) {
            loadList.add(this.configurationId);
            this.loaded = true;
        }
    }

    public LinkedHashSet<Artifact> start() {
        if (!this.loaded) {
            throw new IllegalStateException(this.configurationId + " is not loaded");
        }
        LinkedHashSet<Artifact> startList = new LinkedHashSet<Artifact>();
        this.startInternal(startList);
        this.userLoaded = true;
        this.userStarted = true;
        return startList;
    }

    private void startInternal(LinkedHashSet<Artifact> startList) {
        for (ConfigurationStatus parent : this.startParents) {
            if (parent.isStarted()) continue;
            parent.startInternal(startList);
        }
        if (!this.started) {
            startList.add(this.configurationId);
            this.started = true;
        }
    }

    public LinkedHashSet<Artifact> stop(boolean gc) {
        LinkedHashSet<ConfigurationStatus> stopStatuses = new LinkedHashSet<ConfigurationStatus>();
        this.stopInternal(stopStatuses, gc);
        LinkedHashSet<Artifact> stopIds = new LinkedHashSet<Artifact>(stopStatuses.size());
        for (ConfigurationStatus configurationStatus : stopStatuses) {
            stopIds.add(configurationStatus.configurationId);
        }
        return stopIds;
    }

    private void stopInternal(LinkedHashSet<ConfigurationStatus> stopList, boolean gc) {
        if (!this.started) {
            return;
        }
        for (ConfigurationStatus child : this.startChildren) {
            if (!child.isStarted()) continue;
            child.stopInternal(stopList, gc);
        }
        if (this.started) {
            this.started = false;
            this.userStarted = false;
            stopList.add(this);
            if (gc) {
                for (ConfigurationStatus parent : this.startParents) {
                    if (parent.isUserStarted() || !stopList.containsAll(parent.startChildren)) continue;
                    parent.stopInternal(stopList, gc);
                }
            }
        }
    }

    public LinkedHashSet<Artifact> restart() {
        if (!this.started) {
            throw new IllegalStateException(this.configurationId + " is not started");
        }
        LinkedHashSet<ConfigurationStatus> restartStatuses = new LinkedHashSet<ConfigurationStatus>();
        this.restartInternal(restartStatuses);
        LinkedHashSet<Artifact> restartIds = new LinkedHashSet<Artifact>(restartStatuses.size());
        for (ConfigurationStatus configurationStatus : restartStatuses) {
            restartIds.add(configurationStatus.configurationId);
        }
        this.userLoaded = true;
        this.userStarted = true;
        return restartIds;
    }

    private void restartInternal(LinkedHashSet<ConfigurationStatus> restartList) {
        if (!this.started) {
            return;
        }
        for (ConfigurationStatus child : this.startChildren) {
            if (!child.isStarted()) continue;
            child.restartInternal(restartList);
        }
        restartList.add(this);
    }

    public LinkedHashSet<Artifact> unload(boolean gc) {
        LinkedHashSet<ConfigurationStatus> unloadStatuses = new LinkedHashSet<ConfigurationStatus>();
        this.unloadInternal(unloadStatuses, gc);
        LinkedHashSet<Artifact> unloadIds = new LinkedHashSet<Artifact>(unloadStatuses.size());
        for (ConfigurationStatus configurationStatus : unloadStatuses) {
            unloadIds.add(configurationStatus.configurationId);
        }
        return unloadIds;
    }

    private void unloadInternal(LinkedHashSet<ConfigurationStatus> unloadList, boolean gc) {
        if (!this.loaded) {
            return;
        }
        for (ConfigurationStatus child : this.loadChildren) {
            if (!child.isLoaded()) continue;
            child.unloadInternal(unloadList, gc);
        }
        if (this.loaded) {
            this.started = false;
            this.userStarted = false;
            this.loaded = false;
            this.userLoaded = false;
            unloadList.add(this);
            if (gc) {
                for (ConfigurationStatus parent : this.loadParents) {
                    if (parent.isUserLoaded() || !unloadList.containsAll(parent.loadChildren)) continue;
                    parent.unloadInternal(unloadList, gc);
                }
            }
        }
    }

    public LinkedHashSet<Artifact> reload() {
        if (!this.loaded) {
            throw new IllegalStateException(this.configurationId + " is not loaded");
        }
        LinkedHashSet<ConfigurationStatus> reloadStatuses = new LinkedHashSet<ConfigurationStatus>();
        this.reloadInternal(reloadStatuses);
        LinkedHashSet<Artifact> reloadIds = new LinkedHashSet<Artifact>(reloadStatuses.size());
        for (ConfigurationStatus configurationStatus : reloadStatuses) {
            reloadIds.add(configurationStatus.configurationId);
        }
        this.userLoaded = true;
        return reloadIds;
    }

    private void reloadInternal(LinkedHashSet<ConfigurationStatus> reloadList) {
        if (!this.loaded) {
            return;
        }
        for (ConfigurationStatus child : this.loadChildren) {
            if (!child.isLoaded()) continue;
            child.reloadInternal(reloadList);
        }
        reloadList.add(this);
    }

    public String toString() {
        String load = this.userLoaded ? "user-loaded" : (this.loaded ? "loaded" : "not-loaded");
        String start = this.userLoaded ? "user-started" : (this.loaded ? "started" : "not-started");
        return "[" + this.configurationId + " " + load + " " + start + "]";
    }
}

