/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jmxremoting;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.rmi.server.RMIServerSocketFactory;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.NotificationFilterSupport;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.jmxremoting.Authenticator;
import org.apache.geronimo.jmxremoting.JMXConnector;
import org.apache.geronimo.jmxremoting.JMXConnectorInfo;
import org.apache.geronimo.management.geronimo.KeystoreManager;
import org.apache.geronimo.system.jmx.MBeanServerReference;

public class JMXSecureConnector
extends JMXConnector {
    private KeystoreManager keystoreManager;
    private String algorithm;
    private String secureProtocol;
    private String keyStore;
    private String trustStore;
    private String keyAlias;
    private boolean clientAuth;
    public static final GBeanInfo GBEAN_INFO;

    public JMXSecureConnector(MBeanServerReference mbeanServerReference, String objectName, ClassLoader classLoader) {
        this(mbeanServerReference.getMBeanServer(), objectName, classLoader);
    }

    public JMXSecureConnector(MBeanServer mbeanServer, String objectName, ClassLoader classLoader) {
        super(mbeanServer, objectName, classLoader);
    }

    public void setKeystoreManager(KeystoreManager keystoreManager) {
        this.keystoreManager = keystoreManager;
    }

    public KeystoreManager getKeystoreManager() {
        return this.keystoreManager;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(String trustStore) {
        this.trustStore = trustStore;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = "default".equalsIgnoreCase(algorithm) ? KeyManagerFactory.getDefaultAlgorithm() : algorithm;
    }

    public String getSecureProtocol() {
        return this.secureProtocol;
    }

    public void setSecureProtocol(String secureProtocol) {
        this.secureProtocol = secureProtocol;
    }

    public void setClientAuth(boolean clientAuth) {
        this.clientAuth = clientAuth;
    }

    public boolean isClientAuth() {
        return this.clientAuth;
    }

    @Override
    public void doStart() throws Exception {
        this.jmxServiceURL = new JMXServiceURL(this.protocol, this.host, this.port, this.urlPath);
        HashMap<String, Object> env = new HashMap<String, Object>();
        Authenticator authenticator = null;
        if (this.applicationConfigName != null) {
            authenticator = new Authenticator(this.applicationConfigName, this.classLoader);
            env.put("jmx.remote.authenticator", authenticator);
        } else {
            this.log.warn("Starting unauthenticating JMXConnector for " + this.jmxServiceURL);
        }
        SSLServerSocketFactory sssf = this.keystoreManager.createSSLServerFactory(null, this.secureProtocol, this.algorithm, this.keyStore, this.keyAlias, this.trustStore, this.classLoader);
        GeronimoSslRMIServerSocketFactory rssf = new GeronimoSslRMIServerSocketFactory(sssf, this.host, this.clientAuth);
        SslRMIClientSocketFactory rcsf = new SslRMIClientSocketFactory();
        env.put("jmx.remote.rmi.server.socket.factory", rssf);
        env.put("jmx.remote.rmi.client.socket.factory", rcsf);
        this.server = JMXConnectorServerFactory.newJMXConnectorServer(this.jmxServiceURL, env, this.mbeanServer);
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType("jmx.remote.connection.opened");
        filter.enableType("jmx.remote.connection.closed");
        filter.enableType("jmx.remote.connection.failed");
        this.server.addNotificationListener(authenticator, filter, null);
        this.server.start();
        this.log.debug("Started JMXConnector " + this.server.getAddress());
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"JMX Secure Remoting Connector", JMXSecureConnector.class);
        infoFactory.addReference("MBeanServerReference", MBeanServerReference.class);
        infoFactory.addAttribute("objectName", String.class, false);
        infoFactory.addAttribute("classLoader", ClassLoader.class, false);
        infoFactory.addAttribute("protocol", String.class, true, true);
        infoFactory.addAttribute("host", String.class, true, true);
        infoFactory.addAttribute("port", Integer.TYPE, true, true);
        infoFactory.addAttribute("urlPath", String.class, true, true);
        infoFactory.addAttribute("applicationConfigName", String.class, true, true);
        infoFactory.addInterface(JMXConnectorInfo.class);
        infoFactory.addReference("KeystoreManager", KeystoreManager.class);
        infoFactory.addAttribute("algorithm", String.class, true, true);
        infoFactory.addAttribute("secureProtocol", String.class, true, true);
        infoFactory.addAttribute("keyStore", String.class, true, true);
        infoFactory.addAttribute("keyAlias", String.class, true, true);
        infoFactory.addAttribute("trustStore", String.class, true, true);
        infoFactory.addAttribute("clientAuth", Boolean.TYPE, true, true);
        infoFactory.setConstructor(new String[]{"MBeanServerReference", "objectName", "classLoader"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }

    private static class GeronimoSslRMIServerSocketFactory
    implements RMIServerSocketFactory {
        private SSLServerSocketFactory sssf;
        private boolean clientAuth;
        private InetAddress bindAddress;

        public GeronimoSslRMIServerSocketFactory(SSLServerSocketFactory sssf, String bindHost, boolean clientAuth) throws UnknownHostException {
            this.sssf = sssf;
            this.bindAddress = InetAddress.getByName(bindHost);
            this.clientAuth = clientAuth;
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            SSLServerSocket ss = (SSLServerSocket)this.sssf.createServerSocket(port, 0, this.bindAddress);
            ss.setNeedClientAuth(this.clientAuth);
            return ss;
        }
    }
}

