/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.ClassPathList;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.ModuleList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathUtils {
    private static final Logger log = LoggerFactory.getLogger(ClassPathUtils.class);
    private static final int manifestClassLoaderMode;
    private static final String manifestClassLoaderMessage;
    private static final int MFCP_LENIENT = 1;
    private static final int MFCP_STRICT = 2;

    public static void addManifestClassPath(JarFile moduleFile, URI moduleBaseUri, LinkedHashSet<String> classPath, JarFileFactory factory, List<DeploymentException> problems) throws DeploymentException {
        String manifestClassPath;
        try {
            manifestClassPath = factory.getManifestClassPath(moduleFile);
        }
        catch (IOException e) {
            problems.add(new DeploymentException("Could not read manifest: " + moduleBaseUri, (Throwable)e));
            return;
        }
        if (manifestClassPath == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(manifestClassPath, " ");
        while (tokenizer.hasMoreTokens()) {
            URI pathUri;
            String path = tokenizer.nextToken();
            try {
                pathUri = new URI(path);
            }
            catch (URISyntaxException e) {
                problems.add(new DeploymentException("Invalid manifest classpath entry: module= " + moduleBaseUri + ", path= " + path));
                continue;
            }
            if (pathUri.isAbsolute()) {
                problems.add(new DeploymentException("Manifest class path entries must be relative (J2EE 1.4 Section 8.2): path= " + path + ", module= " + moduleBaseUri));
                continue;
            }
            URI targetUri = moduleBaseUri.resolve(pathUri);
            try {
                if (factory.isDirectory(targetUri)) {
                    if (!targetUri.getPath().endsWith("/")) {
                        targetUri = URI.create(targetUri.getPath() + "/");
                    }
                    for (File file : factory.listFiles(targetUri)) {
                        if (file.isDirectory()) {
                            log.debug("Sub directory [" + file.getAbsolutePath() + "] in the manifest entry directory is ignored");
                            continue;
                        }
                        if (!file.getName().endsWith(".jar")) {
                            log.debug("Only jar files are added to classpath, file [" + file.getAbsolutePath() + "] is ignored");
                            continue;
                        }
                        classPath.add(targetUri.resolve(file.getName()).getPath());
                    }
                    continue;
                }
                if (!pathUri.getPath().endsWith(".jar")) {
                    if (manifestClassLoaderMode == 2) {
                        problems.add(new DeploymentException("Manifest class path entries must end with the .jar extension (J2EE 1.4 Section 8.2): path= " + path + ", module= " + moduleBaseUri));
                        continue;
                    }
                    log.info("The " + manifestClassLoaderMessage + " processing mode is in effect.\n" + "Therefore, a manifest classpath entry which does not end with .jar, " + pathUri + " is being permitted and ignored.");
                    continue;
                }
                classPath.add(targetUri.getPath());
            }
            catch (IOException e) {
                if (manifestClassLoaderMode == 2) {
                    problems.add(new DeploymentException("An IOException resulting from manifest classpath : targetUri= " + targetUri, (Throwable)e));
                    continue;
                }
                log.info("The " + manifestClassLoaderMessage + " processing mode is in effect.\n" + "Therefore, an IOException resulting from manifest classpath " + targetUri + " is being ignored.");
            }
        }
    }

    public static void getCompleteManifestClassPath(JarFile moduleFile, URI moduleBaseUri, URI resolutionUri, ClassPathList classpath, ModuleList exclusions, JarFileFactory factory, List<DeploymentException> problems) throws DeploymentException {
        String manifestClassPath;
        try {
            manifestClassPath = factory.getManifestClassPath(moduleFile);
        }
        catch (IOException e) {
            problems.add(new DeploymentException(ClassPathUtils.printInfo("Could not read manifest: " + moduleBaseUri, moduleBaseUri, classpath, exclusions), (Throwable)e));
            return;
        }
        if (manifestClassPath == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(manifestClassPath, " ");
        while (tokenizer.hasMoreTokens()) {
            URI pathUri;
            String path = tokenizer.nextToken();
            try {
                pathUri = new URI(path);
            }
            catch (URISyntaxException e) {
                problems.add(new DeploymentException(ClassPathUtils.printInfo("Invalid manifest classpath entry, path= " + path, moduleBaseUri, classpath, exclusions)));
                continue;
            }
            if (pathUri.isAbsolute()) {
                problems.add(new DeploymentException(ClassPathUtils.printInfo("Manifest class path entries must be relative (J2EE 1.4 Section 8.2): path= " + path, moduleBaseUri, classpath, exclusions)));
                continue;
            }
            URI targetUri = moduleBaseUri.resolve(pathUri);
            try {
                if (factory.isDirectory(targetUri)) {
                    if (!targetUri.getPath().endsWith("/")) {
                        targetUri = URI.create(targetUri.getPath() + "/");
                    }
                    for (File file : factory.listFiles(targetUri)) {
                        if (file.isDirectory()) {
                            log.debug("Sub directory [" + file.getAbsolutePath() + "] in the manifest entry directory is ignored");
                            continue;
                        }
                        if (!file.getName().endsWith(".jar")) {
                            log.debug("Only jar files are added to classpath, file [" + file.getAbsolutePath() + "] is ignored");
                            continue;
                        }
                        ClassPathUtils.addToClassPath(moduleBaseUri, resolutionUri, targetUri.resolve(file.getName()), classpath, exclusions, factory, problems);
                    }
                    continue;
                }
                if (!pathUri.getPath().endsWith(".jar")) {
                    if (manifestClassLoaderMode == 2) {
                        problems.add(new DeploymentException(ClassPathUtils.printInfo("Manifest class path entries must end with the .jar extension (J2EE 1.4 Section 8.2): path= " + path, moduleBaseUri, classpath, exclusions)));
                        continue;
                    }
                    log.info("The " + manifestClassLoaderMessage + " processing mode is in effect.\n" + "Therefore, a manifest classpath entry which does not end with .jar, " + pathUri + " is being permitted and ignored.");
                    continue;
                }
                ClassPathUtils.addToClassPath(moduleBaseUri, resolutionUri, targetUri, classpath, exclusions, factory, problems);
            }
            catch (IOException e) {
                if (manifestClassLoaderMode == 2) {
                    problems.add(new DeploymentException("An IOException resulting from manifest classpath : targetUri= " + targetUri, (Throwable)e));
                    continue;
                }
                log.info("The " + manifestClassLoaderMessage + " processing mode is in effect.\n" + "Therefore, an IOException resulting from manifest classpath " + targetUri + " is being ignored.");
            }
        }
    }

    private static void addToClassPath(URI moduleBaseUri, URI resolutionUri, URI targetUri, ClassPathList classpath, ModuleList exclusions, JarFileFactory factory, List<DeploymentException> problems) throws DeploymentException {
        JarFile classPathJarFile;
        String targetEntry = targetUri.toString();
        if (exclusions.contains(targetEntry)) {
            return;
        }
        URI resolvedUri = resolutionUri.resolve(targetUri);
        String classpathEntry = resolvedUri.toString();
        if (classpath.contains(classpathEntry)) {
            return;
        }
        classpath.add(classpathEntry);
        try {
            classPathJarFile = factory.newJarFile(targetUri);
        }
        catch (IOException e) {
            if (manifestClassLoaderMode == 2) {
                problems.add(new DeploymentException(ClassPathUtils.printInfo("Manifest class path entries must be a valid jar file, or if it is a directory, all the files with jar suffix in it must be a valid jar file (JAVAEE 5 Section 8.2):  resolved to targetURI= " + targetUri, moduleBaseUri, classpath, exclusions), (Throwable)e));
            } else {
                log.info("The " + manifestClassLoaderMessage + " processing mode is in effect.\n" + "Therefore, an IOException resulting from manifest classpath " + targetUri + " is being ignored.");
            }
            return;
        }
        ClassPathUtils.getCompleteManifestClassPath(classPathJarFile, targetUri, resolutionUri, classpath, exclusions, factory, problems);
    }

    private static String printInfo(String message, URI moduleBaseUri, ClassPathList classpath, ModuleList exclusions) {
        StringBuffer buf = new StringBuffer(message).append("\n");
        buf.append("    looking at: ").append(moduleBaseUri);
        buf.append("    current classpath: ").append(classpath);
        buf.append("    ignoring modules: ").append(exclusions);
        return buf.toString();
    }

    static {
        String mode = System.getProperty("Xorg.apache.geronimo.deployment.LenientMFCP");
        int mfcpMode = 2;
        String mfcpModeMessage = "Strict Manifest Classpath";
        if (mode != null && mode.equals("true")) {
            mfcpMode = 1;
            mfcpModeMessage = "Lenient Manifest Classpath";
        }
        manifestClassLoaderMode = mfcpMode;
        manifestClassLoaderMessage = mfcpModeMessage;
        LoggerFactory.getLogger(DeploymentContext.class).info("The " + manifestClassLoaderMessage + " processing mode is in effect.\n" + "This option can be altered by specifying -DXorg.apache.geronimo.deployment.LenientMFCP=true|false\n" + "Specify =\"true\" for more lenient processing such as ignoring missing jars and references that are not spec compliant.");
    }

    static interface JarFileFactory {
        public JarFile newJarFile(URI var1) throws IOException;

        public String getManifestClassPath(JarFile var1) throws IOException;

        public boolean isDirectory(URI var1) throws IOException;

        public File[] listFiles(URI var1) throws IOException;
    }
}

