/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment;

import java.util.Collection;
import java.util.Collections;
import org.apache.geronimo.deployment.AbstractNamespaceBuilder;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.ReferenceCollection;
import org.apache.geronimo.gbean.ReferenceCollectionEvent;
import org.apache.geronimo.gbean.ReferenceCollectionListener;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.QNameSetSpecification;

public abstract class AbstractBuilderCollection<T extends AbstractNamespaceBuilder> {
    protected final Collection<T> builders;
    protected QNameSet specQNames = QNameSet.EMPTY;
    protected QNameSet planQNames = QNameSet.EMPTY;

    protected AbstractBuilderCollection(Collection<T> builders) {
        Collection collection = this.builders = builders == null ? Collections.emptySet() : builders;
        if (builders instanceof ReferenceCollection) {
            ((ReferenceCollection)builders).addReferenceCollectionListener(new ReferenceCollectionListener(){

                public void memberAdded(ReferenceCollectionEvent event) {
                    AbstractBuilderCollection.this.addBuilder((AbstractNamespaceBuilder)event.getMember());
                }

                public void memberRemoved(ReferenceCollectionEvent event) {
                    AbstractNamespaceBuilder builder = (AbstractNamespaceBuilder)event.getMember();
                    QNameSet builderSpecQNames = builder.getSpecQNameSet();
                    AbstractBuilderCollection.this.specQNames = AbstractBuilderCollection.this.specQNames.intersect((QNameSetSpecification)builderSpecQNames.inverse());
                    QNameSet builderPlanQNames = builder.getPlanQNameSet();
                    AbstractBuilderCollection.this.planQNames = AbstractBuilderCollection.this.planQNames.intersect((QNameSetSpecification)builderPlanQNames.inverse());
                    XmlBeansUtil.unregisterSubstitutionGroupElements(builder.getBaseQName(), builderPlanQNames);
                }
            });
        }
        for (AbstractNamespaceBuilder builder : this.builders) {
            this.addBuilder(builder);
        }
    }

    protected void addBuilder(T builder) {
        QNameSet builderSpecQNames = builder.getSpecQNameSet();
        QNameSet builderPlanQNames = builder.getPlanQNameSet();
        if (builderSpecQNames == null) {
            throw new IllegalStateException("Builder " + builder + " is missing spec qnames");
        }
        if (builderPlanQNames == null) {
            throw new IllegalStateException("Builder " + builder + " is missing plan qnames");
        }
        if (!this.specQNames.isDisjoint((QNameSetSpecification)builderSpecQNames) && !this.planQNames.isDisjoint((QNameSetSpecification)builderPlanQNames)) {
            throw new IllegalArgumentException("Duplicate builderSpecQNames in builder set: " + builderSpecQNames + " and duplicate builderPlanQNames in builder set: " + builderPlanQNames);
        }
        try {
            this.specQNames = this.specQNames.union((QNameSetSpecification)builderSpecQNames);
            this.planQNames = this.planQNames.union((QNameSetSpecification)builderPlanQNames);
        }
        catch (NullPointerException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("could not merge qnamesets for builder " + builder).initCause(e);
        }
        XmlBeansUtil.registerSubstitutionGroupElements(builder.getBaseQName(), builderPlanQNames);
    }

    public QNameSet getSpecQNameSet() {
        return this.specQNames;
    }

    public QNameSet getPlanQNameSet() {
        return null;
    }
}

