/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.xmlbeans;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.QNameSetSpecification;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlValidationError;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlBeansUtil {
    private static final Map<String, String> NAMESPACE_UPDATES = new HashMap<String, String>();
    private static final Map<QName, QNameSet> substitutionGroups = new HashMap<QName, QNameSet>();
    private static final XmlObject[] NO_ELEMENTS = new XmlObject[0];

    private XmlBeansUtil() {
    }

    public static void registerNamespaceUpdates(Map<String, String> updates) {
        NAMESPACE_UPDATES.putAll(updates);
    }

    public static void unregisterNamespaceUpdates(Map<String, String> updates) {
        NAMESPACE_UPDATES.entrySet().removeAll(updates.entrySet());
    }

    public static XmlObject parse(File file) throws IOException, XmlException {
        ArrayList errors = new ArrayList();
        XmlObject parsed = XmlObject.Factory.parse((File)file, (XmlOptions)XmlBeansUtil.createXmlOptions(errors));
        if (errors.size() != 0) {
            throw new XmlException(errors.toArray().toString());
        }
        return parsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlObject parse(URL url, ClassLoader cl) throws IOException, XmlException {
        XmlObject parsed;
        ArrayList errors = new ArrayList();
        Thread currentThread = Thread.currentThread();
        ClassLoader oldcl = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(cl);
        try {
            parsed = XmlObject.Factory.parse((URL)url, (XmlOptions)XmlBeansUtil.createXmlOptions(errors));
        }
        finally {
            currentThread.setContextClassLoader(oldcl);
        }
        if (errors.size() != 0) {
            throw new XmlException(errors.toArray().toString());
        }
        return parsed;
    }

    public static XmlObject parse(InputStream is) throws IOException, XmlException {
        ArrayList errors = new ArrayList();
        XmlObject parsed = XmlObject.Factory.parse((InputStream)is, (XmlOptions)XmlBeansUtil.createXmlOptions(errors));
        if (errors.size() != 0) {
            throw new XmlException(errors.toArray().toString());
        }
        return parsed;
    }

    public static XmlObject parse(String xml) throws XmlException {
        ArrayList errors = new ArrayList();
        XmlObject parsed = XmlObject.Factory.parse((String)xml, (XmlOptions)XmlBeansUtil.createXmlOptions(errors));
        if (errors.size() != 0) {
            throw new XmlException(errors.toArray().toString());
        }
        return parsed;
    }

    public static XmlObject parse(Element element) throws XmlException {
        ArrayList errors = new ArrayList();
        XmlObject parsed = XmlObject.Factory.parse((Node)element, (XmlOptions)XmlBeansUtil.createXmlOptions(errors));
        if (errors.size() != 0) {
            throw new XmlException(errors.toArray().toString());
        }
        return parsed;
    }

    public static XmlOptions createXmlOptions(Collection errors) {
        XmlOptions options = new XmlOptions();
        options.setLoadLineNumbers();
        options.setErrorListener(errors);
        options.setLoadSubstituteNamespaces(NAMESPACE_UPDATES);
        return options;
    }

    public static void registerSubstitutionGroupElements(QName substitutionGroup, QNameSet substitutions) {
        QNameSet oldSubstitutions = substitutionGroups.get(substitutionGroup);
        if (oldSubstitutions != null) {
            substitutions = oldSubstitutions.union((QNameSetSpecification)substitutions);
        }
        substitutionGroups.put(substitutionGroup, substitutions);
    }

    public static void unregisterSubstitutionGroupElements(QName substitutionGroup, QNameSet substitutions) {
        QNameSet oldSubstitutions = substitutionGroups.get(substitutionGroup);
        if (oldSubstitutions != null && substitutions != null) {
            QNameSet difference = oldSubstitutions.intersect((QNameSetSpecification)substitutions.inverse());
            substitutionGroups.put(substitutionGroup, difference);
        }
    }

    public static QNameSet getQNameSetForSubstitutionGroup(QName substitutionGroup) {
        return substitutionGroups.get(substitutionGroup);
    }

    public static XmlObject[] selectSubstitutionGroupElements(QName substitutionGroup, XmlObject container) {
        QNameSet substitutionGroupMembers = XmlBeansUtil.getQNameSetForSubstitutionGroup(substitutionGroup);
        if (substitutionGroupMembers == null) {
            return NO_ELEMENTS;
        }
        return container.selectChildren(substitutionGroupMembers);
    }

    public static XmlObject typedCopy(XmlObject in, SchemaType type) throws XmlException {
        XmlObject out = in.copy().changeType(type);
        XmlBeansUtil.validateDD(out);
        return out;
    }

    public static void validateDD(XmlObject dd) throws XmlException {
        XmlOptions xmlOptions = new XmlOptions();
        xmlOptions.setLoadLineNumbers();
        ArrayList errors = new ArrayList();
        xmlOptions.setErrorListener(errors);
        try {
            if (!dd.validate(xmlOptions)) {
                Iterator iterator = errors.iterator();
                block3: while (iterator.hasNext()) {
                    Object o = iterator.next();
                    if (!(o instanceof XmlValidationError)) continue;
                    XmlValidationError validationError = (XmlValidationError)o;
                    List expected = validationError.getExpectedQNames();
                    QName actual = validationError.getOffendingQName();
                    if (expected == null) continue;
                    for (QName expectedQName : expected) {
                        QNameSet substitutions = XmlBeansUtil.getQNameSetForSubstitutionGroup(expectedQName);
                        if (substitutions == null || !substitutions.contains(actual)) continue;
                        iterator.remove();
                        continue block3;
                    }
                }
                if (!errors.isEmpty()) {
                    StringBuffer buf = new StringBuffer("Invalid deployment descriptor: errors:\n\n");
                    for (Object o : errors) {
                        buf.append(o).append("\n\n");
                    }
                    buf.append("Descriptor:\n").append(dd.toString()).append("\n");
                    throw new XmlException(buf.toString(), null, errors);
                }
            }
        }
        catch (NullPointerException e) {
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }
}

