/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.enterprise.deploy.spi.DeploymentManager;
import org.apache.geronimo.cli.deployer.CommandArgs;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.cli.AbstractCommand;
import org.apache.geronimo.deployment.cli.ConsoleReader;
import org.apache.geronimo.deployment.cli.ServerConnection;
import org.apache.geronimo.deployment.plugin.jmx.RemoteDeploymentManager;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.InternalKernelException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.NoSuchOperationException;

public class CommandUnlockKeystore
extends AbstractCommand {
    private static final String KEYSTORE_TRUSTSTORE_PASSWORD_FILE = "org.apache.geronimo.keyStoreTrustStorePasswordFile";
    private static final String GERONIMO_HOME = "org.apache.geronimo.home.dir";
    private static final String GERONIMO_SERVER = "org.apache.geronimo.server.dir";
    private static final String DEFAULT_KEYSTORE_TRUSTSTORE_PASSWORD_FILE = System.getProperty("org.apache.geronimo.server.dir") + "/var/config/config-substitutions.properties";

    @Override
    public void execute(ConsoleReader consoleReader, ServerConnection connection, CommandArgs commandArgs) throws DeploymentException {
        String[] args = commandArgs.getArgs();
        if (args.length == 0) {
            throw new DeploymentException("Specify the key store name to be unlocked");
        }
        DeploymentManager dm = connection.getDeploymentManager();
        Kernel kernel = null;
        if (dm instanceof RemoteDeploymentManager) {
            kernel = ((RemoteDeploymentManager)dm).getKernel();
        }
        AbstractNameQuery anq = new AbstractNameQuery("org.apache.geronimo.management.geronimo.KeystoreManager");
        Set it = kernel.listGBeans(anq);
        AbstractName an = (AbstractName)it.iterator().next();
        try {
            kernel.invoke(an, "initializeKeystores");
        }
        catch (GBeanNotFoundException e1) {
            throw new DeploymentException("Unable to find the gbean associated with initializeKeystores");
        }
        catch (NoSuchOperationException e1) {
            throw new DeploymentException("Operation initializeKeystores does not exist");
        }
        catch (InternalKernelException e1) {
            throw new DeploymentException();
        }
        catch (Exception e1) {
            throw new DeploymentException();
        }
        if (args.length >= 1) {
            try {
                Properties properties = this.loadTrustStorePasswordFile();
                AbstractName keyStoreAbName = this.getKeyStoreAbstractName(kernel, args[0]);
                this.unLockKeyStore(kernel, keyStoreAbName, properties, args[0]);
                this.emit(consoleReader, "Successfuly unlocked the keystore:: " + args[0]);
                for (int i = 1; i < args.length; ++i) {
                    this.unlockKeyAlias(kernel, keyStoreAbName, properties, args[0], args[i]);
                    this.emit(consoleReader, "Successfuly unlocked the private key:: " + args[i]);
                }
            }
            catch (FileNotFoundException e) {
                throw new DeploymentException("Unable to read the keystore password from the specified file:: " + System.getProperty(KEYSTORE_TRUSTSTORE_PASSWORD_FILE, DEFAULT_KEYSTORE_TRUSTSTORE_PASSWORD_FILE), (Throwable)e);
            }
            catch (IOException e) {
                throw new DeploymentException("Unable to read the keystore password from the specified file:: " + System.getProperty(KEYSTORE_TRUSTSTORE_PASSWORD_FILE, DEFAULT_KEYSTORE_TRUSTSTORE_PASSWORD_FILE), (Throwable)e);
            }
        }
    }

    private Properties loadTrustStorePasswordFile() throws DeploymentException {
        Properties props = new Properties();
        FileInputStream fstream = null;
        try {
            fstream = new FileInputStream(System.getProperty(KEYSTORE_TRUSTSTORE_PASSWORD_FILE, DEFAULT_KEYSTORE_TRUSTSTORE_PASSWORD_FILE));
            props.load(fstream);
            Properties properties = props;
            return properties;
        }
        catch (FileNotFoundException e) {
            throw new DeploymentException("Unable to read specified file:: " + System.getProperty(KEYSTORE_TRUSTSTORE_PASSWORD_FILE, DEFAULT_KEYSTORE_TRUSTSTORE_PASSWORD_FILE), (Throwable)e);
        }
        catch (IOException e) {
            throw new DeploymentException("Unable to read specified file:: " + System.getProperty(KEYSTORE_TRUSTSTORE_PASSWORD_FILE, DEFAULT_KEYSTORE_TRUSTSTORE_PASSWORD_FILE), (Throwable)e);
        }
        finally {
            if (fstream != null) {
                try {
                    fstream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private String getKeyAliasPassword(Properties properties, String keyStoreName, String aliasName, Kernel kernel) throws DeploymentException {
        String aliasPassword = properties.getProperty(aliasName);
        AbstractName abstractName = null;
        String decryptedPassword = null;
        if (aliasPassword == null) {
            throw new DeploymentException("No alias with the name " + aliasName + " exists in the keyStoreTruststore password properties file::" + System.getProperty(KEYSTORE_TRUSTSTORE_PASSWORD_FILE, DEFAULT_KEYSTORE_TRUSTSTORE_PASSWORD_FILE));
        }
        AbstractNameQuery abstractNameQuery = new AbstractNameQuery("org.apache.geronimo.system.util.EncryptionManagerWrapperGBean");
        Iterator it = kernel.listGBeans(abstractNameQuery).iterator();
        abstractName = (AbstractName)it.next();
        try {
            decryptedPassword = (String)kernel.invoke(abstractName, "decrypt", new Object[]{aliasPassword}, new String[]{"java.lang.String"});
        }
        catch (GBeanNotFoundException e) {
            throw new DeploymentException("Unable to find the gbean with the abstractname:: " + abstractName, (Throwable)e);
        }
        catch (NoSuchOperationException e) {
            throw new DeploymentException("No method decrypt available with:: " + abstractName, (Throwable)e);
        }
        catch (InternalKernelException e) {
            throw new DeploymentException();
        }
        catch (Exception e) {
            throw new DeploymentException();
        }
        return decryptedPassword;
    }

    public AbstractName getKeyStoreAbstractName(Kernel kernel, String keyStoreName) throws DeploymentException {
        AbstractNameQuery abstractNameQuery = new AbstractNameQuery("org.apache.geronimo.management.geronimo.KeystoreInstance");
        for (AbstractName abstractName : kernel.listGBeans(abstractNameQuery)) {
            String curKeyStoreName;
            try {
                curKeyStoreName = (String)kernel.getAttribute(abstractName, "keystoreName");
            }
            catch (Exception e) {
                throw new DeploymentException("No keystore exists with the name::" + keyStoreName, (Throwable)e);
            }
            if (!keyStoreName.equals(curKeyStoreName)) continue;
            return abstractName;
        }
        throw new DeploymentException("No keystore exists with the name::" + keyStoreName);
    }

    private String getKeyStorePassword(Properties properties, String keyStoreName, Kernel kernel) throws DeploymentException {
        String keyStorePassword = properties.getProperty(keyStoreName);
        AbstractName abstractName = null;
        String decryptedPassword = null;
        if (keyStorePassword == null) {
            throw new DeploymentException("No keyStorePassword attribute named " + keyStoreName + " exists in the keyStoreTruststore password properties file::" + System.getProperty(KEYSTORE_TRUSTSTORE_PASSWORD_FILE, DEFAULT_KEYSTORE_TRUSTSTORE_PASSWORD_FILE));
        }
        AbstractNameQuery abstractNameQuery = new AbstractNameQuery("org.apache.geronimo.system.util.EncryptionManagerWrapperGBean");
        Iterator it = kernel.listGBeans(abstractNameQuery).iterator();
        abstractName = (AbstractName)it.next();
        try {
            decryptedPassword = (String)kernel.invoke(abstractName, "decrypt", new Object[]{keyStorePassword}, new String[]{"java.lang.String"});
        }
        catch (GBeanNotFoundException e) {
            throw new DeploymentException("Unable to find the gbean with the abstractname:: " + abstractName, (Throwable)e);
        }
        catch (NoSuchOperationException e) {
            throw new DeploymentException("No method decrypt available with:: " + abstractName, (Throwable)e);
        }
        catch (InternalKernelException e) {
            throw new DeploymentException();
        }
        catch (Exception e) {
            throw new DeploymentException();
        }
        return decryptedPassword;
    }

    public boolean unlockKeyAlias(Kernel kernel, AbstractName keyStoreAbName, Properties properties, String keyStoreName, String aliasName) throws DeploymentException, FileNotFoundException {
        char[] aliasPassword = this.getKeyAliasPassword(properties, keyStoreName, aliasName, kernel).toCharArray();
        char[] keyStorePassword = this.getKeyStorePassword(properties, keyStoreName, kernel).toCharArray();
        boolean success = false;
        Object[] argsVariable = new Object[]{aliasName, keyStorePassword, aliasPassword};
        String[] argsType = new String[]{aliasName.getClass().getName(), keyStorePassword.getClass().getName(), aliasPassword.getClass().getName()};
        try {
            kernel.invoke(keyStoreAbName, "unlockPrivateKey", argsVariable, argsType);
            success = true;
        }
        catch (GBeanNotFoundException e) {
            throw new DeploymentException("Unable to find the gbean with the abstractname:: " + keyStoreAbName, (Throwable)e);
        }
        catch (NoSuchOperationException e) {
            throw new DeploymentException("No such method unlockPrivateKey available with:: " + keyStoreAbName, (Throwable)e);
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
        return success;
    }

    public void unLockKeyStore(Kernel kernel, AbstractName keyStoreAbName, Properties properties, String keyStoreName) throws DeploymentException {
        char[] keyStorepassword = this.getKeyStorePassword(properties, keyStoreName, kernel).toCharArray();
        try {
            kernel.invoke(keyStoreAbName, "unlockKeystore", new Object[]{keyStorepassword}, new String[]{keyStorepassword.getClass().getName()});
        }
        catch (GBeanNotFoundException e) {
            throw new DeploymentException("Unable to find the gbean with the abstractname:: " + keyStoreAbName, (Throwable)e);
        }
        catch (NoSuchOperationException e) {
            throw new DeploymentException("No such method unlockPrivateKey available with:: " + keyStoreAbName, (Throwable)e);
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }
}

