/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.IOException;
import javax.enterprise.deploy.spi.Target;
import org.apache.geronimo.cli.deployer.CommandArgs;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.cli.AbstractCommand;
import org.apache.geronimo.deployment.cli.ConsoleReader;
import org.apache.geronimo.deployment.cli.ServerConnection;

public class CommandListTargets
extends AbstractCommand {
    @Override
    public void execute(ConsoleReader consoleReader, ServerConnection connection, CommandArgs commandArgs) throws DeploymentException {
        try {
            Target[] list = connection.getDeploymentManager().getTargets();
            if (list == null || list.length == 0) {
                consoleReader.printString("No available targets.");
                consoleReader.printNewline();
            } else {
                consoleReader.printString("Available Targets:");
                consoleReader.printNewline();
                for (int i = 0; i < list.length; ++i) {
                    Target target = list[i];
                    consoleReader.printString("  " + target.getName());
                    consoleReader.printNewline();
                }
            }
        }
        catch (IOException e) {
            throw new DeploymentException("Could not write to console", (Throwable)e);
        }
    }
}

