/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.apache.geronimo.cli.deployer.CommandArgs;
import org.apache.geronimo.cli.deployer.InstallBundleCommandArgs;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.cli.AbstractCommand;
import org.apache.geronimo.deployment.cli.ConsoleReader;
import org.apache.geronimo.deployment.cli.DeployUtils;
import org.apache.geronimo.deployment.cli.DeploymentSyntaxException;
import org.apache.geronimo.deployment.cli.ServerConnection;
import org.apache.geronimo.deployment.plugin.GeronimoDeploymentManager;
import org.apache.geronimo.deployment.plugin.jmx.RemoteDeploymentManager;
import org.osgi.jmx.framework.FrameworkMBean;

public class CommandInstallBundle
extends AbstractCommand {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(ConsoleReader consoleReader, ServerConnection connection, CommandArgs commandArgs) throws DeploymentException {
        if (!this.isOffline(connection)) {
            if (!(commandArgs instanceof InstallBundleCommandArgs)) {
                throw new DeploymentSyntaxException("CommandArgs has the type [" + commandArgs.getClass() + "]; expected [" + InstallBundleCommandArgs.class + "]");
            }
            InstallBundleCommandArgs recordBundleCommandArgs = (InstallBundleCommandArgs)commandArgs;
            File bundleFile = new File(recordBundleCommandArgs.getArgs()[0]);
            if (!(bundleFile.exists() && bundleFile.isFile() && bundleFile.canRead())) {
                throw new DeploymentException("File does not exist or not a normal file or not readable. " + bundleFile);
            }
            DeploymentManager dmgr = connection.getDeploymentManager();
            if (!(dmgr instanceof GeronimoDeploymentManager)) throw new DeploymentException("Unable to record bundle using " + dmgr.getClass().getName() + " deployment manager");
            GeronimoDeploymentManager mgr = (GeronimoDeploymentManager)dmgr;
            boolean start = recordBundleCommandArgs.isStart();
            int startLevel = recordBundleCommandArgs.getStartLevel();
            String groupId = recordBundleCommandArgs.getGroupId();
            try {
                long bundleId = mgr.recordInstall(bundleFile, groupId, startLevel);
                if (bundleId > 0L) {
                    consoleReader.printString(DeployUtils.reformat("Installed and recorded bundle: " + bundleId, 4, 72));
                    if (!start) return;
                    if (mgr instanceof RemoteDeploymentManager) {
                        MBeanServerConnection mbsc = ((RemoteDeploymentManager)mgr).getJMXConnector().getMBeanServerConnection();
                        try {
                            FrameworkMBean frameworkMBean = this.getFrameworkMBean(mbsc);
                            frameworkMBean.startBundle(bundleId);
                            consoleReader.printString(DeployUtils.reformat("Started bundle: " + bundleId, 4, 72));
                            return;
                        }
                        catch (Exception e) {
                            throw new DeploymentException("Unable to start bundle.", (Throwable)e);
                        }
                    }
                    consoleReader.printString(DeployUtils.reformat("Currently the start option only support JMX connection.", 4, 72));
                    return;
                }
                consoleReader.printString(DeployUtils.reformat("Bundle installation failed, so did not record bundle.", 4, 72));
                return;
            }
            catch (Exception e) {
                throw new DeploymentException("Unable to record bundle " + recordBundleCommandArgs.getArgs()[0], (Throwable)e);
            }
        }
        try {
            consoleReader.printString(DeployUtils.reformat("Install bundle offline is not supported!", 4, 72));
            return;
        }
        catch (IOException e) {
            throw new DeploymentException("Install bundle offline is not supported!");
        }
    }

    private FrameworkMBean getFrameworkMBean(MBeanServerConnection mbsc) throws Exception {
        Set<ObjectName> objectNameSet = mbsc.queryNames(new ObjectName("osgi.core:type=framework,*"), null);
        if (objectNameSet.isEmpty()) {
            throw new Exception("Framework mbean not found");
        }
        if (objectNameSet.size() == 1) {
            return MBeanServerInvocationHandler.newProxyInstance(mbsc, objectNameSet.iterator().next(), FrameworkMBean.class, false);
        }
        throw new Exception("Found multiple framework mbeans");
    }
}

