/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.apache.geronimo.deployment.cli.DeployUtils;
import org.apache.geronimo.deployment.cli.InputPrompt;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.util.Main;
import org.apache.geronimo.system.jmx.KernelDelegate;

public class StopServer
implements Main {
    public static final String RMI_NAMING_CONFG_ID = "org/apache/geronimo/RMINaming";
    public static final String DEFAULT_PORT = "1099";
    String host;
    String port;
    String user;
    String password;
    boolean secure = false;
    private String[] args;
    public static final GBeanInfo GBEAN_INFO;

    public static void main(String[] args) throws Exception {
        StopServer cmd = new StopServer();
        cmd.execute(args);
    }

    public int execute(Object opaque) {
        if (!(opaque instanceof String[])) {
            throw new IllegalArgumentException("Argument type is [" + opaque.getClass() + "]; expected [" + String[].class + "]");
        }
        this.args = (String[])opaque;
        int i = 0;
        while (i < this.args.length && this.args[i].startsWith("--")) {
            if (!this.setParam(i++)) continue;
            ++i;
        }
        if (i < this.args.length) {
            this.printUsage();
        }
        Integer portI = null;
        if (this.port != null) {
            try {
                portI = new Integer(this.port);
            }
            catch (NumberFormatException e) {
                System.out.println("Invalid port number specified.");
                return 1;
            }
        }
        if (this.user == null && this.password == null) {
            String uri = DeployUtils.getConnectionURI(this.host, portI, this.secure);
            try {
                DeployUtils.SavedAuthentication savedAuthentication = DeployUtils.readSavedCredentials(uri);
                if (savedAuthentication != null) {
                    this.user = savedAuthentication.getUser();
                    this.password = new String(savedAuthentication.getPassword());
                }
            }
            catch (IOException e) {
                System.out.println("Warning: " + e.getMessage());
            }
        }
        if (this.user == null || this.password == null) {
            try {
                InputPrompt prompt = new InputPrompt(System.in, System.out);
                if (this.user == null) {
                    this.user = prompt.getInput("Username: ");
                }
                if (this.password == null) {
                    this.password = prompt.getPassword("Password: ");
                }
            }
            catch (IOException e) {
                System.out.println("Unable to prompt for login.");
                return 1;
            }
        }
        try {
            if (this.port == null) {
                this.port = DEFAULT_PORT;
            }
            if (this.host == null) {
                this.host = "localhost";
            }
            System.out.print("Locating server on " + this.host + ":" + this.port + "... ");
            Kernel kernel = null;
            try {
                kernel = this.getRunningKernel();
            }
            catch (IOException e) {
                System.out.println();
                System.out.println("Could not communicate with the server.  The server may not be running or the port number may be incorrect (" + e.getMessage() + ")");
            }
            if (kernel != null) {
                System.out.println("Server found.");
                System.out.println("Server shutdown started");
                kernel.shutdown();
                System.out.println("Server shutdown completed");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    private boolean argumentHasValue(int i) {
        return i + 1 < this.args.length && !this.args[i + 1].startsWith("--");
    }

    private boolean setParam(int i) {
        if (this.argumentHasValue(i)) {
            if (this.args[i].equals("--user")) {
                this.user = this.args[++i];
            } else if (this.args[i].equals("--password")) {
                this.password = this.args[++i];
            } else if (this.args[i].equals("--port")) {
                this.port = this.args[++i];
            } else if (this.args[i].equals("--host")) {
                this.host = this.args[++i];
            } else {
                this.printUsage();
            }
            return true;
        }
        if (this.args[i].equals("--secure")) {
            this.secure = true;
        } else {
            this.printUsage();
        }
        return false;
    }

    public Kernel getRunningKernel() throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jmx.remote.credentials", new String[]{this.user, this.password});
        String connectorName = "/JMXConnector";
        if (this.secure) {
            connectorName = "/JMXSecureConnector";
            SslRMIClientSocketFactory csf = new SslRMIClientSocketFactory();
            map.put("jmx.remote.rmi.client.socket.factory", csf);
        }
        KernelDelegate kernel = null;
        try {
            JMXServiceURL address = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + this.host + ":" + this.port + connectorName);
            JMXConnector jmxConnector = JMXConnectorFactory.connect(address, map);
            MBeanServerConnection mbServerConnection = jmxConnector.getMBeanServerConnection();
            kernel = new KernelDelegate(mbServerConnection);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return kernel;
    }

    public void printUsage() {
        System.out.println();
        System.out.println("Command-line shutdown syntax:");
        System.out.println("    shutdown [options]");
        System.out.println();
        System.out.println("The available options are:");
        System.out.println("    --user <username>");
        System.out.println("    --password <password>");
        System.out.println("    --host <hostname>");
        System.out.println("    --port <port>");
        System.out.println("    --secure");
        System.exit(1);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(StopServer.class, (String)"StopServer");
        infoBuilder.addInterface(Main.class);
        infoBuilder.setConstructor(new String[0]);
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

