/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import jline.ConsoleReader;
import org.apache.geronimo.cli.deployer.CommandArgs;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.common.FileUtils;
import org.apache.geronimo.deployment.cli.AbstractCommand;
import org.apache.geronimo.deployment.cli.DeployUtils;
import org.apache.geronimo.deployment.cli.DeploymentSyntaxException;
import org.apache.geronimo.deployment.cli.ServerConnection;

public class CommandRedeploy
extends AbstractCommand {
    public void execute(ConsoleReader consoleReader, ServerConnection connection, CommandArgs commandArgs) throws DeploymentException {
        ProgressObject po;
        try {
            TargetModuleID[] done;
            TargetModuleID[] allModules;
            String[] args = commandArgs.getArgs();
            if (args.length == 0) {
                throw new DeploymentSyntaxException("Must specify a module or plan (or both) and optionally module IDs to replace");
            }
            DeploymentManager mgr = connection.getDeploymentManager();
            Target[] allTargets = mgr.getTargets();
            try {
                allModules = mgr.getAvailableModules(null, allTargets);
            }
            catch (TargetException e) {
                throw new DeploymentException("Unable to load modules from server", (Throwable)e);
            }
            ArrayList modules = new ArrayList();
            File module = null;
            File plan = null;
            File test = new File(args[0]);
            if (!test.exists()) {
                throw new DeploymentSyntaxException("Module or plan file does not exist: " + test.getAbsolutePath());
            }
            if (!test.canRead()) {
                throw new DeploymentException("Cannot read file " + test.getAbsolutePath());
            }
            try {
                if (FileUtils.isJarFile((File)test) || test.isDirectory()) {
                    module = test;
                } else {
                    plan = test;
                }
            }
            catch (IOException e) {
                throw new DeploymentException("Invalid JAR File " + args[0]);
            }
            if (args.length > 1) {
                test = new File(args[1]);
                if (test.exists() && test.canRead() && !args[1].equals(args[0])) {
                    try {
                        if (FileUtils.isJarFile((File)test) || test.isDirectory()) {
                            if (module != null) {
                                throw new DeploymentSyntaxException("Module and plan cannot both be JAR files or directories!");
                            }
                            module = test;
                        }
                        if (plan != null) {
                            throw new DeploymentSyntaxException("Module or plan must be a JAR file or directory!");
                        }
                        plan = test;
                    }
                    catch (IOException e) {
                        throw new DeploymentException("Invalid JAR File " + args[1]);
                    }
                } else {
                    modules.addAll(DeployUtils.identifyTargetModuleIDs((TargetModuleID[])allModules, (String)args[1], (boolean)false));
                }
            }
            for (int i = 2; i < args.length; ++i) {
                modules.addAll(DeployUtils.identifyTargetModuleIDs((TargetModuleID[])allModules, (String)args[i], (boolean)false));
            }
            if (modules.size() == 0 && connection.isGeronimo()) {
                this.emit(consoleReader, "No ModuleID or TargetModuleID provided.  Attempting to guess based on the content of the " + (plan == null ? "archive" : "plan") + ".");
                String moduleId = null;
                try {
                    if (plan != null) {
                        moduleId = DeployUtils.extractModuleIdFromPlan((File)plan);
                        if (moduleId == null) {
                            String fileName = module == null ? plan.getName() : module.getName();
                            int pos = fileName.lastIndexOf(46);
                            String artifactId = pos > -1 ? module.getName().substring(0, pos) : module.getName();
                            moduleId = "default/" + artifactId + "//";
                            this.emit(consoleReader, "Unable to locate Geronimo deployment plan in archive.  Calculating default ModuleID from archive name.");
                        }
                    } else if (module != null && (moduleId = DeployUtils.extractModuleIdFromArchive((File)module)) == null) {
                        int pos = module.getName().lastIndexOf(46);
                        String artifactId = pos > -1 ? module.getName().substring(0, pos) : module.getName();
                        moduleId = "default/" + artifactId + "//";
                        this.emit(consoleReader, "Unable to locate Geronimo deployment plan in archive.  Calculating default ModuleID from archive name.");
                    }
                }
                catch (IOException e) {
                    throw new DeploymentException("Unable to read input files: " + e.getMessage(), (Throwable)e);
                }
                if (moduleId != null) {
                    this.emit(consoleReader, "Attempting to use ModuleID '" + moduleId + "'");
                    modules.addAll(DeployUtils.identifyTargetModuleIDs((TargetModuleID[])allModules, (String)moduleId, (boolean)true));
                } else {
                    this.emit(consoleReader, "Unable to calculate a ModuleID from supplied module and/or plan.");
                }
            }
            if (modules.size() == 0) {
                throw new DeploymentSyntaxException("No ModuleID or TargetModuleID available.  Nothing to do.  Maybe you should add a ModuleID or TargetModuleID to the command line?");
            }
            if (module != null) {
                module = module.getAbsoluteFile();
            }
            if (plan != null) {
                plan = plan.getAbsoluteFile();
            }
            TargetModuleID[] ids = modules.toArray(new TargetModuleID[modules.size()]);
            boolean multiple = CommandRedeploy.isMultipleTargets(ids);
            po = mgr.redeploy(ids, module, plan);
            this.waitForProgress(consoleReader, po);
            for (TargetModuleID id : done = po.getResultTargetModuleIDs()) {
                this.emit(consoleReader, "Redeployed " + id.getModuleID() + (multiple ? " on " + id.getTarget().getName() : "") + (id.getWebURL() == null ? "" : " @ " + id.getWebURL()));
                if (id.getChildTargetModuleID() == null) continue;
                for (int j = 0; j < id.getChildTargetModuleID().length; ++j) {
                    TargetModuleID child = id.getChildTargetModuleID()[j];
                    this.emit(consoleReader, "  `-> " + child.getModuleID() + (child.getWebURL() == null ? "" : " @ " + child.getWebURL()));
                }
            }
        }
        catch (IOException e) {
            throw new DeploymentException("Could not write to console", (Throwable)e);
        }
        if (po.getDeploymentStatus().isFailed()) {
            throw new DeploymentException("Operation failed: " + po.getDeploymentStatus().getMessage());
        }
    }
}

