/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Properties;
import java.util.jar.JarFile;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.apache.geronimo.cli.deployer.ConnectionParams;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.crypto.EncryptionManager;
import org.apache.geronimo.deployment.cli.DeployUtils;
import org.apache.geronimo.deployment.cli.DeploymentSyntaxException;
import org.apache.geronimo.deployment.cli.InputPrompt;
import org.apache.geronimo.deployment.cli.OfflineDeployerStarter;
import org.apache.geronimo.deployment.plugin.factories.AuthenticationFailedException;
import org.apache.geronimo.deployment.plugin.jmx.JMXDeploymentManager;
import org.apache.geronimo.deployment.plugin.jmx.LocalDeploymentManager;
import org.apache.geronimo.kernel.Kernel;

public class ServerConnection {
    private static final String DEFAULT_URI = "deployer:geronimo:jmx";
    private final DeploymentFactory geronimoDeploymentFactory;
    private DeploymentManager manager;
    private Writer out;
    private InputStream in;
    private SavedAuthentication auth;
    private boolean logToSysErr;
    private boolean verboseMessages;

    public ServerConnection(ConnectionParams params, PrintWriter out, InputStream in, Kernel kernel, DeploymentFactory geronimoDeploymentFactory) throws DeploymentException {
        if (null == kernel) {
            throw new IllegalArgumentException("kernel is required");
        }
        this.geronimoDeploymentFactory = geronimoDeploymentFactory;
        this.out = out;
        this.in = in;
        boolean offline = false;
        String uri = params.getURI();
        String driver = params.getDriver();
        String user = params.getUser();
        String password = params.getPassword();
        String host = params.getHost();
        Integer port = params.getPort();
        this.verboseMessages = params.isVerbose();
        this.logToSysErr = params.isSyserr();
        offline = params.isOffline();
        if (driver != null && uri == null) {
            throw new DeploymentSyntaxException("A custom driver requires a custom URI");
        }
        if (host != null || port != null) {
            uri = "deployer:geronimo:jmx://" + (host == null ? "" : host) + (port == null ? "" : ":" + port);
        }
        if (offline) {
            this.startOfflineDeployer(kernel);
            this.manager = new LocalDeploymentManager(kernel);
        } else {
            this.tryToConnect(uri, driver, user, password, true);
        }
        if (this.manager == null) {
            throw new DeploymentException("Unexpected error; connection failed.");
        }
    }

    protected void startOfflineDeployer(Kernel kernel) throws DeploymentException {
        OfflineDeployerStarter offlineDeployerStarter = new OfflineDeployerStarter(kernel);
        offlineDeployerStarter.start();
    }

    public void close() throws DeploymentException {
        if (this.manager != null) {
            this.manager.release();
        }
    }

    Serializable getAuthentication() {
        return this.auth;
    }

    String getServerURI() {
        return this.auth.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToConnect(String argURI, String driver, String user, String password, boolean authPrompt) throws DeploymentException {
        String useURI;
        DeploymentFactoryManager mgr = DeploymentFactoryManager.getInstance();
        if (driver != null) {
            this.loadDriver(driver, mgr);
        } else {
            mgr.registerDeploymentFactory(this.geronimoDeploymentFactory);
        }
        String string = useURI = argURI == null ? DEFAULT_URI : argURI;
        if (authPrompt && user == null && password == null) {
            File authFile;
            InputStream in = ServerConnection.class.getResourceAsStream("/.geronimo-deployer");
            if (in == null && (authFile = new File(System.getProperty("user.home"), ".geronimo-deployer")).exists() && authFile.canRead()) {
                try {
                    in = new BufferedInputStream(new FileInputStream(authFile));
                }
                catch (FileNotFoundException e) {
                    // empty catch block
                }
            }
            if (in != null) {
                try {
                    Properties props = new Properties();
                    props.load(in);
                    String encrypted = props.getProperty("login." + useURI);
                    if (encrypted != null) {
                        if (encrypted.startsWith("{Plain}")) {
                            int pos = encrypted.indexOf("/");
                            user = encrypted.substring(7, pos);
                            password = encrypted.substring(pos + 1);
                        } else {
                            Serializable o = EncryptionManager.decrypt((String)encrypted);
                            if (o == encrypted) {
                                System.out.print(DeployUtils.reformat("Unknown encryption used in saved login file", 4, 72));
                            } else {
                                SavedAuthentication auth = (SavedAuthentication)o;
                                if (auth.uri.equals(useURI)) {
                                    user = auth.user;
                                    password = new String(auth.password);
                                }
                            }
                        }
                    }
                }
                catch (IOException e) {
                    System.out.print(DeployUtils.reformat("Unable to read authentication from saved login file: " + e.getMessage(), 4, 72));
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        if (authPrompt && !useURI.equals(DEFAULT_URI) && user == null && password == null) {
            this.doAuthPromptAndRetry(useURI, user, password);
            return;
        }
        try {
            this.manager = mgr.getDeploymentManager(useURI, user, password);
            this.auth = new SavedAuthentication(useURI, user, password == null ? null : password.toCharArray());
        }
        catch (AuthenticationFailedException e) {
            if (authPrompt) {
                this.doAuthPromptAndRetry(useURI, user, password);
                return;
            }
            throw new DeploymentException("Login Failed");
        }
        catch (DeploymentManagerCreationException e) {
            throw new DeploymentException("Unable to connect to server at " + useURI + " -- " + e.getMessage(), (Throwable)e);
        }
        if (this.manager instanceof JMXDeploymentManager) {
            JMXDeploymentManager deploymentManager = (JMXDeploymentManager)this.manager;
            deploymentManager.setLogConfiguration(this.logToSysErr, this.verboseMessages);
        }
    }

    private void loadDriver(String driver, DeploymentFactoryManager mgr) throws DeploymentException {
        File file = new File(driver);
        if (!(file.exists() && file.canRead() && DeployUtils.isJarFile((File)file))) {
            throw new DeploymentSyntaxException("Driver '" + file.getAbsolutePath() + "' is not a readable JAR file");
        }
        String className = null;
        try {
            JarFile jar = new JarFile(file);
            className = jar.getManifest().getMainAttributes().getValue("J2EE-DeploymentFactory-Implementation-Class");
            if (className == null) {
                throw new DeploymentException("The driver JAR " + file.getAbsolutePath() + " does not specify a J2EE-DeploymentFactory-Implementation-Class; cannot load driver.");
            }
            jar.close();
            DeploymentFactory factory = (DeploymentFactory)Class.forName(className).newInstance();
            mgr.registerDeploymentFactory(factory);
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentSyntaxException("Unable to load driver class " + className + " from JAR " + file.getAbsolutePath(), e);
        }
    }

    private void doAuthPromptAndRetry(String uri, String user, String password) throws DeploymentException {
        try {
            InputPrompt prompt = new InputPrompt(this.in, this.out);
            if (user == null) {
                user = prompt.getInput("Username: ");
            }
            if (password == null) {
                password = prompt.getPassword("Password: ");
            }
        }
        catch (IOException e) {
            throw new DeploymentException("Unable to prompt for login", (Throwable)e);
        }
        this.tryToConnect(uri, null, user, password, false);
    }

    public DeploymentManager getDeploymentManager() {
        return this.manager;
    }

    public boolean isGeronimo() {
        return this.manager.getClass().getName().startsWith("org.apache.geronimo.");
    }

    private static final class SavedAuthentication
    implements Serializable {
        private String uri;
        private String user;
        private char[] password;

        public SavedAuthentication(String uri, String user, char[] password) {
            this.uri = uri;
            this.user = user;
            this.password = password;
        }
    }
}

