/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.security.auth.login.FailedLoginException;
import jline.ConsoleReader;
import org.apache.geronimo.cli.deployer.CommandArgs;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.cli.AbstractCommand;
import org.apache.geronimo.deployment.cli.CommandInstallCAR;
import org.apache.geronimo.deployment.cli.DeployUtils;
import org.apache.geronimo.deployment.cli.ServerConnection;
import org.apache.geronimo.deployment.plugin.GeronimoDeploymentManager;
import org.apache.geronimo.kernel.config.NoSuchStoreException;
import org.apache.geronimo.system.plugin.DownloadResults;
import org.apache.geronimo.system.plugin.PluginInstallerGBean;
import org.apache.geronimo.system.plugin.model.ArtifactType;
import org.apache.geronimo.system.plugin.model.PluginArtifactType;
import org.apache.geronimo.system.plugin.model.PluginListType;
import org.apache.geronimo.system.plugin.model.PluginType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandListConfigurations
extends AbstractCommand {
    @Override
    public void execute(ConsoleReader consoleReader, ServerConnection connection, CommandArgs commandArgs) throws DeploymentException {
        DeploymentManager dmgr = connection.getDeploymentManager();
        if (dmgr instanceof GeronimoDeploymentManager) {
            GeronimoDeploymentManager mgr = (GeronimoDeploymentManager)dmgr;
            try {
                String repo = commandArgs.getArgs().length == 1 ? commandArgs.getArgs()[0] : this.getRepository(consoleReader, mgr);
                PluginListType plugins = this.getPluginCategories(repo, mgr, consoleReader);
                if (plugins == null) {
                    return;
                }
                PluginListType list = this.getInstallList(plugins, consoleReader, repo);
                if (list == null) {
                    return;
                }
                this.installPlugins(mgr, list, repo, consoleReader, connection);
            }
            catch (IOException e) {
                throw new DeploymentException("Unable to install configuration", (Throwable)e);
            }
            catch (NumberFormatException e) {
                throw new DeploymentException("Invalid response");
            }
        } else {
            throw new DeploymentException("Cannot list repositories using " + dmgr.getClass().getName() + " deployment manager");
        }
    }

    public String getRepository(ConsoleReader consoleReader, GeronimoDeploymentManager mgr) throws IOException, DeploymentException {
        URL[] all = mgr.getRepositories();
        if (all.length == 0) {
            throw new DeploymentException("No default repositories available.  Please either specify the repository URL on the command line, or go into the console Plugin page and update the list of available repositories.");
        }
        if (all.length == 1) {
            String repo = all[0].toString();
            consoleReader.printNewline();
            consoleReader.printString("Selected repository: " + repo);
            consoleReader.printNewline();
            return repo;
        }
        consoleReader.printNewline();
        consoleReader.printString("Select repository:");
        consoleReader.printNewline();
        for (int i = 0; i < all.length; ++i) {
            URL url = all[i];
            DeployUtils.printTo("  " + (i + 1) + ". ", 8, consoleReader);
            DeployUtils.println(url.toString(), 0, consoleReader);
        }
        String entry = consoleReader.readLine("Enter Repository Number: ").trim();
        if (entry.length() == 0) {
            return null;
        }
        try {
            int index = Integer.parseInt(entry);
            return all[index - 1].toString();
        }
        catch (NumberFormatException e) {
            throw new DeploymentException("Invalid selection");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DeploymentException("Invalid selection");
        }
    }

    public PluginListType getPluginCategories(String repo, GeronimoDeploymentManager mgr, ConsoleReader consoleReader) throws DeploymentException, IOException {
        PluginListType data;
        if (repo == null) {
            return null;
        }
        try {
            URL repository = new URL(repo);
            data = mgr.listPlugins(repository, null, null);
        }
        catch (IOException e) {
            throw new DeploymentException("Unable to list configurations", (Throwable)e);
        }
        catch (FailedLoginException e) {
            throw new DeploymentException("Invalid login for Maven repository '" + repo + "'", (Throwable)e);
        }
        if (data == null || data.getPlugin().size() == 0) {
            return null;
        }
        return data;
    }

    public PluginListType getLocalPluginCategories(GeronimoDeploymentManager mgr, ConsoleReader consoleReader) throws DeploymentException, IOException {
        PluginListType data;
        try {
            data = mgr.createPluginListForRepositories(null);
        }
        catch (NoSuchStoreException e) {
            throw new DeploymentException("Unable to list configurations", (Throwable)e);
        }
        if (data == null || data.getPlugin().size() == 0) {
            return null;
        }
        return data;
    }

    private Map<String, Collection<PluginType>> writePluginList(PluginListType data, ConsoleReader consoleReader) throws IOException {
        if (data == null) {
            consoleReader.printNewline();
            consoleReader.printString("No plugins were returned from this site.");
            consoleReader.printNewline();
            consoleReader.flushConsole();
            return null;
        }
        TreeMap<String, Collection<PluginType>> categories = new TreeMap<String, Collection<PluginType>>();
        Comparator<PluginType> comp = new Comparator<PluginType>(){

            @Override
            public int compare(PluginType o1, PluginType o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        for (PluginType metadata : data.getPlugin()) {
            TreeSet<PluginType> list;
            String category = metadata.getCategory();
            if (category == null) {
                category = "<no category>";
            }
            if ((list = (TreeSet<PluginType>)categories.get(category)) == null) {
                list = new TreeSet<PluginType>(comp);
                categories.put(category, list);
            }
            list.add(metadata);
        }
        return categories;
    }

    public PluginListType getInstallList(PluginListType plugins, ConsoleReader consoleReader, String repo) throws IOException {
        Map<String, Collection<PluginType>> categories = this.writePluginList(plugins, consoleReader);
        if (categories == null) {
            return null;
        }
        ArrayList<PluginType> available = new ArrayList<PluginType>();
        for (Map.Entry<String, Collection<PluginType>> entry : categories.entrySet()) {
            String category = entry.getKey();
            Collection<PluginType> items = entry.getValue();
            consoleReader.printString(category);
            consoleReader.printNewline();
            for (PluginType metadata : items) {
                for (PluginArtifactType instance : metadata.getPluginArtifact()) {
                    PluginType copy = PluginInstallerGBean.copy((PluginType)metadata, (PluginArtifactType)instance);
                    available.add(copy);
                    DeployUtils.printTo("  " + available.size() + ":  ", 10, consoleReader);
                    DeployUtils.println(metadata.getName() + " (" + instance.getModuleId().getVersion() + ")", 0, consoleReader);
                }
            }
        }
        if (available.size() == 0) {
            consoleReader.printNewline();
            consoleReader.printString("No plugins from this site are eligible for installation.");
            consoleReader.printNewline();
            return null;
        }
        consoleReader.printNewline();
        consoleReader.flushConsole();
        String answer = consoleReader.readLine("Install Services [enter a comma separated list of numbers or 'q' to quit]: ").trim();
        if (answer.equalsIgnoreCase("q")) {
            return null;
        }
        PluginListType list = new PluginListType();
        for (String instance : answer.split(",")) {
            int selection = Integer.parseInt(instance.trim());
            PluginType target = (PluginType)available.get(selection - 1);
            list.getPlugin().add(target);
        }
        if (repo != null) {
            list.getDefaultRepository().add(repo);
        }
        return list;
    }

    public void installPlugins(GeronimoDeploymentManager mgr, PluginListType list, String defaultRepository, ConsoleReader consoleReader, ServerConnection connection) throws IOException, DeploymentException {
        long start = System.currentTimeMillis();
        Object key = mgr.startInstall(list, defaultRepository, false, null, null);
        DownloadResults results = CommandInstallCAR.showProgress(consoleReader, mgr, key);
        int time = (int)(System.currentTimeMillis() - start) / 1000;
        CommandInstallCAR.printResults(consoleReader, results, time);
    }

    public void installPlugins(GeronimoDeploymentManager mgr, List<String> list, PluginListType all, String defaultRepository, ConsoleReader consoleReader, ServerConnection connection) throws IOException, DeploymentException {
        PluginListType selected = CommandListConfigurations.getPluginsFromIds(list, all);
        this.installPlugins(mgr, selected, defaultRepository, consoleReader, connection);
    }

    private static PluginListType getPluginsFromIds(List<String> configIds, PluginListType list) throws IllegalStateException {
        PluginListType installList = new PluginListType();
        for (String configId : configIds) {
            PluginType plugin = null;
            block1: for (PluginType metadata : list.getPlugin()) {
                for (PluginArtifactType testInstance : metadata.getPluginArtifact()) {
                    if (!PluginInstallerGBean.toArtifact((ArtifactType)testInstance.getModuleId()).toString().equals(configId)) continue;
                    plugin = PluginInstallerGBean.copy((PluginType)metadata, (PluginArtifactType)testInstance);
                    installList.getPlugin().add(plugin);
                    continue block1;
                }
            }
            if (plugin != null) continue;
            throw new IllegalStateException("No configuration found for '" + configId + "'");
        }
        return installList;
    }

    public void assembleServer(GeronimoDeploymentManager mgr, PluginListType list, String repositoryPath, String relativeServerPath, ConsoleReader consoleReader) throws Exception {
        long start = System.currentTimeMillis();
        DownloadResults results = mgr.installPluginList(repositoryPath, relativeServerPath, list);
        int time = (int)(System.currentTimeMillis() - start) / 1000;
        CommandInstallCAR.printResults(consoleReader, results, time);
    }

    public void assembleServer(GeronimoDeploymentManager mgr, List<String> list, PluginListType all, String repositoryPath, String relativeServerPath, ConsoleReader consoleReader) throws Exception {
        PluginListType selected = CommandListConfigurations.getPluginsFromIds(list, all);
        this.assembleServer(mgr, selected, repositoryPath, relativeServerPath, consoleReader);
    }
}

