/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin.factories;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.apache.geronimo.deployment.ModuleConfigurer;
import org.apache.geronimo.deployment.plugin.factories.BaseDeploymentFactory;
import org.apache.geronimo.deployment.plugin.jmx.RemoteDeploymentManager;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentFactoryWithKernel
extends BaseDeploymentFactory {
    private final Kernel kernel;
    private final RemoteDeploymentManager remoteDeploymentManager;
    public static final GBeanInfo GBEAN_INFO;

    public DeploymentFactoryWithKernel(Kernel kernel) {
        this(kernel, null);
    }

    public DeploymentFactoryWithKernel(Kernel kernel, RemoteDeploymentManager remoteDeploymentManager) {
        if (null == kernel) {
            throw new IllegalArgumentException("kernel is required");
        }
        this.kernel = kernel;
        this.remoteDeploymentManager = remoteDeploymentManager;
        DeploymentFactoryManager.getInstance().registerDeploymentFactory((DeploymentFactory)this);
    }

    @Override
    protected Collection<ModuleConfigurer> getModuleConfigurers() throws DeploymentManagerCreationException {
        ArrayList<ModuleConfigurer> moduleConfigurers = new ArrayList<ModuleConfigurer>();
        Set configurerNames = this.kernel.listGBeans(new AbstractNameQuery(ModuleConfigurer.class.getName()));
        for (AbstractName configurerName : configurerNames) {
            try {
                ModuleConfigurer configurer = (ModuleConfigurer)this.kernel.getGBean(configurerName);
                moduleConfigurers.add(configurer);
            }
            catch (GBeanNotFoundException e) {
                throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)("No gbean found for name returned in query : " + configurerName)))).initCause(e));
            }
        }
        return moduleConfigurers;
    }

    @Override
    protected RemoteDeploymentManager getRemoteDeploymentManager() throws DeploymentManagerCreationException {
        if (this.remoteDeploymentManager != null) {
            return this.remoteDeploymentManager;
        }
        try {
            return (RemoteDeploymentManager)this.kernel.getGBean(RemoteDeploymentManager.class);
        }
        catch (Exception e) {
            throw (DeploymentManagerCreationException)new DeploymentManagerCreationException("See nested").initCause((Throwable)e);
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(DeploymentFactoryWithKernel.class, (String)"DeploymentFactory");
        infoBuilder.addInterface(DeploymentFactory.class);
        infoBuilder.setConstructor(new String[]{"kernel"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

