/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin.local;

import java.util.List;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.TargetModuleID;
import org.apache.geronimo.deployment.plugin.TargetModuleIDImpl;
import org.apache.geronimo.deployment.plugin.local.CommandSupport;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.LifecycleResults;
import org.apache.geronimo.kernel.repository.Artifact;

public class StopCommand
extends CommandSupport {
    private final Kernel kernel;
    private final TargetModuleID[] modules;

    public StopCommand(Kernel kernel, TargetModuleID[] modules) {
        super(CommandType.STOP);
        this.kernel = kernel;
        this.modules = modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            ConfigurationManager configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)this.kernel);
            int alreadyStopped = 0;
            try {
                for (int i = 0; i < this.modules.length; ++i) {
                    TargetModuleID module = this.modules[i];
                    Artifact moduleID = Artifact.create((String)module.getModuleID());
                    LifecycleResults lcresult = null;
                    if (configurationManager.isRunning(moduleID)) {
                        lcresult = configurationManager.stopConfiguration(moduleID);
                        this.addModule(module);
                    } else {
                        this.updateStatus("Module " + moduleID + " is already stopped");
                        ++alreadyStopped;
                    }
                    if (configurationManager.isLoaded(moduleID)) {
                        configurationManager.unloadConfiguration(moduleID);
                    }
                    if (lcresult == null) continue;
                    for (Artifact config : lcresult.getStopped()) {
                        if (config.toString().equals(module.getModuleID())) continue;
                        List kidsChild = StopCommand.loadChildren(this.kernel, config.toString());
                        TargetModuleIDImpl idChild = new TargetModuleIDImpl(null, config.toString(), kidsChild.toArray(new String[kidsChild.size()]));
                        if (StopCommand.isWebApp(this.kernel, config.toString())) {
                            idChild.setType(ModuleType.WAR);
                        }
                        if (idChild.getChildTargetModuleID() != null) {
                            for (int k = 0; k < idChild.getChildTargetModuleID().length; ++k) {
                                TargetModuleIDImpl child = (TargetModuleIDImpl)idChild.getChildTargetModuleID()[k];
                                if (!StopCommand.isWebApp(this.kernel, child.getModuleID())) continue;
                                child.setType(ModuleType.WAR);
                            }
                        }
                        this.addModule(idChild);
                    }
                }
            }
            finally {
                ConfigurationUtil.releaseConfigurationManager((Kernel)this.kernel, (ConfigurationManager)configurationManager);
            }
            if (this.getModuleCount() + alreadyStopped < this.modules.length) {
                this.fail("Some modules could not be stopped");
            } else {
                this.complete("Completed");
            }
        }
        catch (Throwable e) {
            this.doFail(e);
        }
    }
}

