/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin.jmx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.deployment.ModuleConfigurer;
import org.apache.geronimo.deployment.plugin.jmx.JMXDeploymentManager;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalDeploymentManager
extends JMXDeploymentManager {
    private static final Log log = LogFactory.getLog(LocalDeploymentManager.class);
    private static final AbstractNameQuery CONFIGURER_QUERY = new AbstractNameQuery(ModuleConfigurer.class.getName());

    public LocalDeploymentManager(Kernel kernel) {
        super(LocalDeploymentManager.loadModuleConfigurers(kernel));
        this.initialize(kernel);
    }

    private static Collection<ModuleConfigurer> loadModuleConfigurers(Kernel kernel) {
        ArrayList<ModuleConfigurer> moduleConfigurers = new ArrayList<ModuleConfigurer>();
        Set configurerNames = kernel.listGBeans(CONFIGURER_QUERY);
        for (Object configurerName : configurerNames) {
            AbstractName name = (AbstractName)configurerName;
            try {
                ModuleConfigurer configurer = (ModuleConfigurer)kernel.getGBean(name);
                moduleConfigurers.add(configurer);
            }
            catch (GBeanNotFoundException e) {
                log.warn((Object)("No gbean found for name returned in query : " + name));
            }
        }
        return moduleConfigurers;
    }
}

