/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.bundle;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.geronimo.kernel.util.IOUtils;

public class Utils {
    public static void regressiveDelete(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        File parent = file.getParentFile();
        if (file.isFile() || file.isDirectory() && file.listFiles().length == 0) {
            file.delete();
            Utils.regressiveDelete(parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendLine(File file, String line) throws IOException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file, true));
            writer.newLine();
            writer.append(line);
            writer.flush();
        }
        catch (Throwable throwable) {
            IOUtils.close(writer);
            throw throwable;
        }
        IOUtils.close(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteLineByKeyword(File file, String keyword) throws IOException {
        BufferedReader reader = null;
        BufferedWriter writer = null;
        File tmpFile = new File(file.getAbsolutePath() + ".tmpfile");
        try {
            reader = new BufferedReader(new FileReader(file));
            writer = new BufferedWriter(new FileWriter(tmpFile));
            String line = null;
            boolean emptyLineFlag = false;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) {
                    writer.append(line);
                    writer.newLine();
                    continue;
                }
                if (line.contains(keyword)) continue;
                if (line.isEmpty()) {
                    emptyLineFlag = true;
                    continue;
                }
                if (emptyLineFlag) {
                    writer.append("");
                    writer.newLine();
                    emptyLineFlag = false;
                }
                writer.append(line);
                writer.newLine();
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(reader);
            IOUtils.close(writer);
            throw throwable;
        }
        IOUtils.close(reader);
        IOUtils.close(writer);
        if (!file.delete()) {
            tmpFile.delete();
            throw new RuntimeException("Can not delete a line in file: " + file.getAbsolutePath());
        }
        tmpFile.renameTo(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String findLineByKeyword(File file, String keyword) throws IOException {
        String string;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || !line.startsWith(keyword)) continue;
                string = line;
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(reader);
            throw throwable;
        }
        {
            IOUtils.close(reader);
            return string;
        }
        IOUtils.close(reader);
        return null;
    }
}

