/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.bundle;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.WritableListableRepository;
import org.apache.geronimo.kernel.util.FileUtils;
import org.apache.geronimo.kernel.util.IOUtils;
import org.apache.geronimo.system.bundle.BundleRecorder;
import org.apache.geronimo.system.bundle.Utils;
import org.apache.geronimo.system.main.ServerStatus;
import org.apache.geronimo.system.plugin.PluginInstallerGBean;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.startlevel.StartLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean
public class BundleRecorderGBean
implements BundleRecorder,
ServerStatus {
    private static final Logger log = LoggerFactory.getLogger(BundleRecorderGBean.class);
    private BundleContext bundleContext;
    StartLevel startLevelService;
    int defaultBundleStartLevel;
    private final PluginInstallerGBean pluginInstaller;
    private final WritableListableRepository writeableRepo;
    private File startupFile;

    public BundleRecorderGBean(@ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel, @ParamSpecial(type=SpecialAttributeType.bundle) Bundle bundle, @ParamReference(name="ServerInfo") ServerInfo serverInfo, @ParamReference(name="PluginInstallerGBean") PluginInstallerGBean installer, @ParamReference(name="Repository", namingType="Repository") WritableListableRepository repository) throws DeploymentException, IOException {
        this.bundleContext = bundle.getBundleContext();
        this.startLevelService = this.getStartLevelService(this.bundleContext);
        this.defaultBundleStartLevel = this.startLevelService.getInitialBundleStartLevel();
        this.pluginInstaller = installer;
        this.writeableRepo = repository;
        this.startupFile = serverInfo.resolveServer("etc/installed-bundles.properties");
    }

    private StartLevel getStartLevelService(BundleContext bundleContext) {
        ServiceReference<?> startLevelRef = bundleContext.getServiceReference(StartLevel.class.getCanonicalName());
        return (StartLevel)bundleContext.getService(startLevelRef);
    }

    private Bundle installBundle(String location, int startLevel) {
        try {
            Bundle installedBundle = this.bundleContext.installBundle(location);
            this.startLevelService.setBundleStartLevel(installedBundle, startLevel);
            return installedBundle;
        }
        catch (BundleException e) {
            log.error("Bundle installation failed: " + location);
            return null;
        }
    }

    private void startBundle(Bundle bundle) {
        if (BundleUtils.canStart((Bundle)bundle)) {
            try {
                bundle.start(1);
            }
            catch (BundleException e) {
                log.error("Bundle " + bundle.getBundleId() + " failed to start: " + e.getMessage());
            }
        }
    }

    private void uninstallBundle(Bundle bundle) {
        try {
            bundle.uninstall();
        }
        catch (BundleException e) {
            log.error("Bundle " + bundle.getBundleId() + " failed to uninstall: " + e.getMessage());
        }
    }

    @Override
    public long recordInstall(File bundleFile, String groupId, int startLevel) throws IOException {
        Bundle bundle;
        if (bundleFile == null || bundleFile.isDirectory()) {
            throw new IllegalArgumentException("The bundle File is not exist " + bundleFile.getPath());
        }
        if (groupId == null || groupId.isEmpty()) {
            groupId = "default";
        }
        Artifact artifact = this.pluginInstaller.installLibrary(bundleFile, groupId);
        String bundleLocation = this.getMvnLocationFromArtifact(artifact);
        if (startLevel <= 0) {
            log.info("Invalid start level or no start level specified, use defalut bundle start level");
            startLevel = this.defaultBundleStartLevel;
        }
        if ((bundle = this.installBundle(bundleLocation, startLevel)) == null) {
            return -1L;
        }
        String recordKey = artifact.toString();
        if (!this.startupFile.exists() || Utils.findLineByKeyword(this.startupFile, recordKey) == null) {
            Utils.appendLine(this.startupFile, recordKey + "=" + String.valueOf(startLevel));
        } else {
            log.warn("The bundle has been recorded: " + recordKey);
        }
        return bundle.getBundleId();
    }

    @Override
    public void eraseUninstall(long bundleId) throws IOException {
        Bundle bundle = this.bundleContext.getBundle(bundleId);
        if (bundle == null) {
            return;
        }
        this.uninstallBundle(bundle);
        String bundleLocation = bundle.getLocation();
        Artifact artifact = this.getArtifactFromMvnLocation(bundleLocation);
        if (artifact == null) {
            return;
        }
        String recordKey = artifact.toString();
        if (Utils.findLineByKeyword(this.startupFile, recordKey) != null) {
            Utils.deleteLineByKeyword(this.startupFile, recordKey);
            File target = this.writeableRepo.getLocation(artifact);
            File versionFolder = target.getParentFile();
            File artifactFolder = target.getParentFile().getParentFile();
            if (target != null && target.exists()) {
                target.delete();
            }
            FileUtils.recursiveDelete(versionFolder);
            Utils.regressiveDelete(artifactFolder);
        }
    }

    private String getMvnLocationFromArtifact(Artifact artifact) {
        if (artifact == null) {
            return null;
        }
        StringBuilder bundleLocation = new StringBuilder();
        bundleLocation.append("mvn:");
        bundleLocation.append(artifact.getGroupId()).append('/').append(artifact.getArtifactId()).append('/').append(artifact.getVersion());
        return bundleLocation.toString();
    }

    private Artifact getArtifactFromMvnLocation(String mvnLocation) {
        if (!mvnLocation.startsWith("mvn:")) {
            return null;
        }
        String artifactString = mvnLocation.substring(4);
        String[] parts = artifactString.split("/");
        if (parts == null || parts.length < 3) {
            return null;
        }
        String groupId = parts[0];
        String artifactId = parts[1];
        String version = parts[2];
        String type = "jar";
        return new Artifact(groupId, artifactId, version, type);
    }

    @Override
    public long getBundleId(String symbolicName, String version) {
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (!symbolicName.equals(bundle.getSymbolicName()) || !version.equals(bundle.getVersion().toString())) continue;
            return bundle.getBundleId();
        }
        return -1L;
    }

    public boolean isServerStarted() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServerStarted(boolean started) {
        if (!this.startupFile.exists()) {
            return;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(this.startupFile));
            String line = null;
            while ((line = reader.readLine()) != null) {
                int pos;
                if ((line = line.trim()).startsWith("#") || (pos = line.indexOf("=")) == -1) continue;
                String name = line.substring(0, pos).trim();
                String startLevel = line.substring(pos + 1).trim();
                String mvnLocation = this.getMvnLocationFromArtifact(Artifact.create(name));
                Bundle bundle = this.findBundle(mvnLocation);
                if (bundle == null && (bundle = this.installBundle(mvnLocation, Integer.parseInt(startLevel))) == null) continue;
                this.startBundle(bundle);
            }
        }
        catch (Exception e) {
            try {
                log.error("Error reading file", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.close(reader);
                throw throwable;
            }
            IOUtils.close(reader);
        }
        IOUtils.close(reader);
    }

    private Bundle findBundle(String location) {
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (!location.equals(bundle.getLocation())) continue;
            return bundle;
        }
        return null;
    }
}

