/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.geronimo.kernel.util.FileUtils;
import org.apache.geronimo.kernel.util.IOUtils;
import org.apache.geronimo.kernel.util.NestedJarFile;
import org.apache.geronimo.kernel.util.UnpackedJarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JarUtils {
    private static final Logger logger = LoggerFactory.getLogger(JarUtils.class);
    public static final File DUMMY_JAR_FILE;
    public static final String TEMP_FILE_NAME;
    private static final boolean jarUrlRewrite;

    private JarUtils() {
    }

    public static void assertTempFile() throws IOException {
        if (DUMMY_JAR_FILE.exists()) {
            return;
        }
        new JarOutputStream((OutputStream)new FileOutputStream(new File(TEMP_FILE_NAME)), new Manifest()).close();
    }

    public static File toTempFile(JarFile jarFile, String path) throws IOException {
        return JarUtils.toTempFile(JarUtils.createJarURL(jarFile, path));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File toTempFile(URL url) throws IOException {
        File file;
        InputStream in = null;
        FileOutputStream out = null;
        JarFile jarFile = null;
        try {
            if (url.getProtocol().equalsIgnoreCase("jar")) {
                String path;
                String baseFileURIString = url.getFile().substring(0, url.getFile().indexOf("!/"));
                File file2 = new File(new URI(baseFileURIString));
                jarFile = new JarFile(file2);
                JarEntry jarEntry = jarFile.getJarEntry(path = url.getFile().substring(url.getFile().indexOf("!/") + 2));
                if (jarEntry == null) throw new FileNotFoundException("JarEntry " + path + " not found in " + file2);
                in = jarFile.getInputStream(jarEntry);
            } else {
                in = url.openStream();
            }
            int index = url.getPath().lastIndexOf(".");
            String extension = null;
            if (index > 0) {
                extension = url.getPath().substring(index);
            }
            File tempFile = FileUtils.createTempFile(extension);
            out = new FileOutputStream(tempFile);
            IOUtils.copy(in, out);
            file = tempFile;
        }
        catch (URISyntaxException e) {
            try {
                throw new IOException("Could not interpret url " + url, e);
            }
            catch (Throwable throwable) {
                IOUtils.close(out);
                IOUtils.close(in);
                JarUtils.close(jarFile);
                throw throwable;
            }
        }
        IOUtils.close(out);
        IOUtils.close(in);
        JarUtils.close(jarFile);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String readAll(URL url) throws IOException {
        String string;
        InputStreamReader reader = null;
        JarFile jarFile = null;
        try {
            if (url.getProtocol().equalsIgnoreCase("jar")) {
                String path;
                File file = new File(url.getFile().substring(5, url.getFile().indexOf("!/")));
                jarFile = new JarFile(file);
                JarEntry jarEntry = jarFile.getJarEntry(path = url.getFile().substring(url.getFile().indexOf("!/") + 2));
                if (jarEntry == null) throw new FileNotFoundException("JarEntry " + path + " not found in " + file);
                reader = new InputStreamReader(jarFile.getInputStream(jarEntry));
            } else {
                reader = new InputStreamReader(url.openStream());
            }
            char[] buffer = new char[4000];
            StringBuilder out = new StringBuilder();
            int count = reader.read(buffer);
            while (count >= 0) {
                out.append(buffer, 0, count);
                count = reader.read(buffer);
            }
            string = out.toString();
        }
        catch (Throwable throwable) {
            IOUtils.close(reader);
            JarUtils.close(jarFile);
            throw throwable;
        }
        IOUtils.close(reader);
        JarUtils.close(jarFile);
        return string;
    }

    public static File toFile(JarFile jarFile) throws IOException {
        if (jarFile instanceof UnpackedJarFile) {
            return ((UnpackedJarFile)jarFile).getBaseDir();
        }
        throw new IOException("jarFile is not a directory");
    }

    public static File toFile(JarFile jarFile, String path) throws IOException {
        if (jarFile instanceof UnpackedJarFile) {
            File baseDir = ((UnpackedJarFile)jarFile).getBaseDir();
            File file = new File(baseDir, path);
            if (!file.isFile()) {
                throw new IOException("No such file: " + file.getAbsolutePath());
            }
            return file;
        }
        String urlString = "jar:" + new File(jarFile.getName()).toURI().toURL() + "!/" + path;
        return JarUtils.toTempFile(new URL(urlString));
    }

    public static URL createJarURL(JarFile jarFile, String path) throws MalformedURLException {
        NestedJarFile nestedJar;
        if (jarFile instanceof NestedJarFile && (nestedJar = (NestedJarFile)jarFile).isUnpacked()) {
            JarFile baseJar = nestedJar.getBaseJar();
            String basePath = nestedJar.getBasePath();
            if (baseJar instanceof UnpackedJarFile) {
                File baseDir = ((UnpackedJarFile)baseJar).getBaseDir();
                baseDir = new File(baseDir, basePath);
                return new File(baseDir, path).toURI().toURL();
            }
        }
        if (jarFile instanceof UnpackedJarFile) {
            File baseDir = ((UnpackedJarFile)jarFile).getBaseDir();
            return new File(baseDir, path).toURI().toURL();
        }
        String urlString = "jar:" + new File(jarFile.getName()).toURI().toURL() + "!/" + path;
        if (jarUrlRewrite) {
            File tempFile = null;
            try {
                tempFile = JarUtils.toTempFile(new URL(urlString));
            }
            catch (IOException e) {
                try {
                    tempFile = FileUtils.createTempFile();
                    tempFile.delete();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
            return tempFile.toURI().toURL();
        }
        return new URL(urlString);
    }

    public static JarFile createJarFile(File jarFile) throws IOException {
        if (jarFile.isDirectory()) {
            return new UnpackedJarFile(jarFile);
        }
        return new JarFile(jarFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyToPackedJar(JarFile inputJar, File outputFile) throws IOException {
        if (inputJar.getClass() == JarFile.class) {
            FileUtils.copyFile(new File(inputJar.getName()), outputFile);
            return;
        }
        if (inputJar instanceof NestedJarFile && ((NestedJarFile)inputJar).isPacked()) {
            NestedJarFile nestedJarFile = (NestedJarFile)inputJar;
            JarFile baseJar = nestedJarFile.getBaseJar();
            String basePath = nestedJarFile.getBasePath();
            if (baseJar instanceof UnpackedJarFile) {
                FileUtils.copyFile(((UnpackedJarFile)baseJar).getFile(basePath), outputFile);
                return;
            }
            FileUtils.copyFile(new File(baseJar.getName()), outputFile);
            return;
        }
        JarOutputStream out = null;
        try {
            out = new JarOutputStream(new FileOutputStream(outputFile));
            byte[] buffer = new byte[4096];
            Enumeration<JarEntry> entries = inputJar.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                InputStream in = inputJar.getInputStream(entry);
                try {
                    out.putNextEntry(new ZipEntry(entry.getName()));
                    try {
                        int count;
                        while ((count = in.read(buffer)) > 0) {
                            out.write(buffer, 0, count);
                        }
                    }
                    finally {
                        out.closeEntry();
                    }
                }
                finally {
                    IOUtils.close(in);
                }
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(out);
            throw throwable;
        }
        IOUtils.close(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void jarDirectory(File sourceDirectory, File destinationFile) throws IOException {
        JarOutputStream out = null;
        try {
            out = new JarOutputStream(new FileOutputStream(destinationFile));
            JarUtils.jarDirectory(sourceDirectory, "", destinationFile, out);
        }
        catch (Throwable throwable) {
            IOUtils.close(out);
            throw throwable;
        }
        IOUtils.close(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void jarDirectory(File baseDirectory, String baseName, File destinationFile, JarOutputStream out) throws IOException {
        File[] files = baseDirectory.listFiles();
        if (null == files) {
            return;
        }
        byte[] buffer = new byte[4096];
        for (File file : files) {
            if (file.equals(destinationFile)) continue;
            String name = baseName + file.getName();
            if (file.isDirectory()) {
                out.putNextEntry(new ZipEntry(name + "/"));
                out.closeEntry();
                JarUtils.jarDirectory(file, name + "/", destinationFile, out);
                continue;
            }
            if (!file.isFile()) continue;
            out.putNextEntry(new ZipEntry(name));
            FileInputStream in = new FileInputStream(file);
            try {
                int count;
                while ((count = ((InputStream)in).read(buffer)) > 0) {
                    out.write(buffer, 0, count);
                }
            }
            finally {
                IOUtils.close(in);
                out.closeEntry();
            }
        }
    }

    private static void createDirectory(File dir) throws IOException {
        boolean success;
        if (dir != null && !dir.exists() && !(success = dir.mkdirs())) {
            throw new IOException("Cannot create directory " + dir.getAbsolutePath());
        }
    }

    public static void unzipToDirectory(ZipInputStream zipIn, File destDir, String prefix, boolean stripPrefix) throws IOException {
        ZipEntry entry = null;
        while ((entry = zipIn.getNextEntry()) != null) {
            if (!entry.getName().startsWith(prefix)) continue;
            String subBasePath = null;
            subBasePath = stripPrefix ? (prefix.equals(entry.getName()) ? "" : entry.getName().substring(prefix.length())) : entry.getName();
            JarUtils.unzipToDirectory(zipIn, entry, destDir, subBasePath);
        }
    }

    public static void unzipToDirectory(ZipInputStream zipIn, File destDir) throws IOException {
        ZipEntry entry = null;
        while ((entry = zipIn.getNextEntry()) != null) {
            JarUtils.unzipToDirectory(zipIn, entry, destDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipToDirectory(ZipFile zipFile, File destDir, String prefix, boolean stripPrefix) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        try {
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().startsWith(prefix)) continue;
                String subBasePath = null;
                subBasePath = stripPrefix ? (prefix.equals(entry.getName()) ? "" : entry.getName().substring(prefix.length())) : entry.getName();
                JarUtils.unzipToDirectory(zipFile, entry, destDir, subBasePath);
            }
        }
        finally {
            zipFile.close();
        }
    }

    public static void unzipToDirectory(ZipFile zipFile, File destDir, String prefix) throws IOException {
        JarUtils.unzipToDirectory(zipFile, destDir, prefix, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipToDirectory(ZipFile zipFile, File destDir) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        try {
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                JarUtils.unzipToDirectory(zipFile, entry, destDir);
            }
        }
        finally {
            zipFile.close();
        }
    }

    private static void unzipToDirectory(ZipInputStream zipIn, ZipEntry entry, File destDir) throws IOException {
        JarUtils.unzipToDirectory(zipIn, entry, destDir, entry.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void unzipToDirectory(ZipInputStream zipIn, ZipEntry entry, File destDir, String subBasePath) throws IOException {
        if (entry.isDirectory()) {
            File dir = new File(destDir, subBasePath);
            JarUtils.createDirectory(dir);
            return;
        }
        File file = new File(destDir, subBasePath);
        JarUtils.createDirectory(file.getParentFile());
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
            IOUtils.copy(zipIn, out);
        }
        catch (Throwable throwable) {
            IOUtils.close(out);
            throw throwable;
        }
        IOUtils.close(out);
    }

    private static void unzipToDirectory(ZipFile zipFile, ZipEntry entry, File destDir) throws IOException {
        JarUtils.unzipToDirectory(zipFile, entry, destDir, entry.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void unzipToDirectory(ZipFile zipFile, ZipEntry entry, File destDir, String subBasePath) throws IOException {
        if (entry.isDirectory()) {
            File dir = new File(destDir, subBasePath);
            JarUtils.createDirectory(dir);
            return;
        }
        File file = new File(destDir, subBasePath);
        JarUtils.createDirectory(file.getParentFile());
        BufferedOutputStream out = null;
        InputStream in = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
            in = zipFile.getInputStream(entry);
            IOUtils.copy(in, out);
        }
        catch (Throwable throwable) {
            IOUtils.close(in);
            IOUtils.close(out);
            throw throwable;
        }
        IOUtils.close(in);
        IOUtils.close(out);
    }

    public static void close(JarFile thing) {
        if (thing != null) {
            try {
                thing.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(ZipFile thing) {
        if (thing != null) {
            try {
                thing.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean isJarFile(File file) throws IOException {
        return JarUtils.isZipFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isZipFile(File file) throws IOException {
        boolean bl;
        if (file.isDirectory()) {
            return false;
        }
        if (!file.canRead()) {
            throw new IOException("Cannot read file " + file.getAbsolutePath());
        }
        if (file.length() < 4L) {
            return false;
        }
        DataInputStream in = null;
        try {
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            bl = in.readInt() == 1347093252;
        }
        catch (Throwable throwable) {
            IOUtils.close(in);
            throw throwable;
        }
        IOUtils.close(in);
        return bl;
    }

    static {
        jarUrlRewrite = Boolean.valueOf(System.getProperty("org.apache.geronimo.kernel.util.JarUtils.jarUrlRewrite", "true"));
        try {
            DUMMY_JAR_FILE = FileUtils.createTempFile(false);
            TEMP_FILE_NAME = DUMMY_JAR_FILE.getCanonicalPath();
            new JarOutputStream((OutputStream)new FileOutputStream(DUMMY_JAR_FILE), new Manifest()).close();
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

